/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.particles.ParticleController;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;

public class ParticleEffect
implements Disposable,
ResourceData.Configurable {
    private Array<ParticleController> controllers;
    private BoundingBox bounds;

    public ParticleEffect() {
        this.controllers = new Array(true, 3, ParticleController.class);
    }

    public ParticleEffect(ParticleEffect effect) {
        this.controllers = new Array(true, effect.controllers.size);
        int i = 0;
        int n = effect.controllers.size;
        while (i < n) {
            this.controllers.add(effect.controllers.get(i).copy());
            ++i;
        }
    }

    public ParticleEffect(ParticleController ... emitters) {
        this.controllers = new Array<ParticleController>(emitters);
    }

    public void init() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).init();
            ++i;
        }
    }

    public void start() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).start();
            ++i;
        }
    }

    public void end() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).end();
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).reset();
            ++i;
        }
    }

    public void update() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).update();
            ++i;
        }
    }

    public void update(float deltaTime) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).update(deltaTime);
            ++i;
        }
    }

    public void draw() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).draw();
            ++i;
        }
    }

    public boolean isComplete() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            if (!this.controllers.get(i).isComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setTransform(Matrix4 transform) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).setTransform(transform);
            ++i;
        }
    }

    public void rotate(Quaternion rotation) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).rotate(rotation);
            ++i;
        }
    }

    public void rotate(Vector3 axis, float angle) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).rotate(axis, angle);
            ++i;
        }
    }

    public void translate(Vector3 translation) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).translate(translation);
            ++i;
        }
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).scale(scaleX, scaleY, scaleZ);
            ++i;
        }
    }

    public void scale(Vector3 scale) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).scale(scale.x, scale.y, scale.z);
            ++i;
        }
    }

    public Array<ParticleController> getControllers() {
        return this.controllers;
    }

    public ParticleController findController(String name) {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            ParticleController emitter = this.controllers.get(i);
            if (emitter.name.equals(name)) {
                return emitter;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void dispose() {
        int i = 0;
        int n = this.controllers.size;
        while (i < n) {
            this.controllers.get(i).dispose();
            ++i;
        }
    }

    public BoundingBox getBoundingBox() {
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        BoundingBox bounds = this.bounds;
        bounds.inf();
        for (ParticleController emitter : this.controllers) {
            bounds.ext(emitter.getBoundingBox());
        }
        return bounds;
    }

    public void setBatch(Array<ParticleBatch<?>> batches) {
        block0: for (ParticleController controller : this.controllers) {
            for (ParticleBatch particleBatch : batches) {
                if (controller.renderer.setBatch(particleBatch)) continue block0;
            }
        }
    }

    public ParticleEffect copy() {
        return new ParticleEffect(this);
    }

    public void save(AssetManager assetManager, ResourceData data) {
        for (ParticleController controller : this.controllers) {
            controller.save(assetManager, data);
        }
    }

    public void load(AssetManager assetManager, ResourceData data) {
        boolean i = false;
        for (ParticleController controller : this.controllers) {
            controller.load(assetManager, data);
        }
    }
}

