/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public abstract class BaseShaderProvider
implements ShaderProvider {
    protected Array<Shader> shaders = new Array();

    @Override
    public Shader getShader(Renderable renderable) {
        Shader shader2;
        Shader suggestedShader = renderable.shader;
        if (suggestedShader != null && suggestedShader.canRender(renderable)) {
            return suggestedShader;
        }
        for (Shader shader2 : this.shaders) {
            if (!shader2.canRender(renderable)) continue;
            return shader2;
        }
        shader2 = this.createShader(renderable);
        if (!shader2.canRender(renderable)) {
            throw new GdxRuntimeException("unable to provide a shader for this renderable");
        }
        shader2.init();
        this.shaders.add(shader2);
        return shader2;
    }

    protected abstract Shader createShader(Renderable var1);

    @Override
    public void dispose() {
        for (Shader shader : this.shaders) {
            shader.dispose();
        }
        this.shaders.clear();
    }
}

