/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;

public class HexagonalTiledMapRenderer
extends BatchTiledMapRenderer {
    private boolean staggerAxisX = true;
    private boolean staggerIndexEven = false;
    private float hexSideLength = 0.0f;

    public HexagonalTiledMapRenderer(TiledMap map) {
        super(map);
        this.init(map);
    }

    public HexagonalTiledMapRenderer(TiledMap map, float unitScale) {
        super(map, unitScale);
        this.init(map);
    }

    public HexagonalTiledMapRenderer(TiledMap map, Batch batch) {
        super(map, batch);
        this.init(map);
    }

    public HexagonalTiledMapRenderer(TiledMap map, float unitScale, Batch batch) {
        super(map, unitScale, batch);
        this.init(map);
    }

    private void init(TiledMap map) {
        Integer length;
        String index;
        String axis = map.getProperties().get("staggeraxis", String.class);
        if (axis != null) {
            this.staggerAxisX = axis.equals("x");
        }
        if ((index = map.getProperties().get("staggerindex", String.class)) != null) {
            this.staggerIndexEven = index.equals("even");
        }
        if ((length = map.getProperties().get("hexsidelength", Integer.class)) != null) {
            this.hexSideLength = length.intValue();
        } else if (this.staggerAxisX) {
            length = map.getProperties().get("tilewidth", Integer.class);
            if (length != null) {
                this.hexSideLength = 0.5f * (float)length.intValue();
            } else {
                TiledMapTileLayer tmtl = (TiledMapTileLayer)map.getLayers().get(0);
                this.hexSideLength = 0.5f * (float)tmtl.getTileWidth();
            }
        } else {
            length = map.getProperties().get("tileheight", Integer.class);
            if (length != null) {
                this.hexSideLength = 0.5f * (float)length.intValue();
            } else {
                TiledMapTileLayer tmtl = (TiledMapTileLayer)map.getLayers().get(0);
                this.hexSideLength = 0.5f * (float)tmtl.getTileHeight();
            }
        }
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer layer) {
        Color batchColor = this.batch.getColor();
        float color = Color.toFloatBits(batchColor.r, batchColor.g, batchColor.b, batchColor.a * layer.getOpacity());
        int layerWidth = layer.getWidth();
        int layerHeight = layer.getHeight();
        float layerTileWidth = (float)layer.getTileWidth() * this.unitScale;
        float layerTileHeight = (float)layer.getTileHeight() * this.unitScale;
        float layerOffsetX = layer.getRenderOffsetX() * this.unitScale;
        float layerOffsetY = -layer.getRenderOffsetY() * this.unitScale;
        float layerHexLength = this.hexSideLength * this.unitScale;
        if (this.staggerAxisX) {
            float tileWidthLowerCorner = (layerTileWidth - layerHexLength) / 2.0f;
            float tileWidthUpperCorner = (layerTileWidth + layerHexLength) / 2.0f;
            float layerTileHeight50 = layerTileHeight * 0.5f;
            int row1 = Math.max(0, (int)((this.viewBounds.y - layerTileHeight50 - layerOffsetX) / layerTileHeight));
            int row2 = Math.min(layerHeight, (int)((this.viewBounds.y + this.viewBounds.height + layerTileHeight - layerOffsetX) / layerTileHeight));
            int col1 = Math.max(0, (int)((this.viewBounds.x - tileWidthLowerCorner - layerOffsetY) / tileWidthUpperCorner));
            int col2 = Math.min(layerWidth, (int)((this.viewBounds.x + this.viewBounds.width + tileWidthUpperCorner - layerOffsetY) / tileWidthUpperCorner));
            int colA = this.staggerIndexEven == (col1 % 2 == 0) ? col1 + 1 : col1;
            int colB = this.staggerIndexEven == (col1 % 2 == 0) ? col1 : col1 + 1;
            int row = row2 - 1;
            while (row >= row1) {
                int col = colA;
                while (col < col2) {
                    this.renderCell(layer.getCell(col, row), tileWidthUpperCorner * (float)col + layerOffsetX, layerTileHeight50 + layerTileHeight * (float)row + layerOffsetY, color);
                    col += 2;
                }
                col = colB;
                while (col < col2) {
                    this.renderCell(layer.getCell(col, row), tileWidthUpperCorner * (float)col + layerOffsetX, layerTileHeight * (float)row + layerOffsetY, color);
                    col += 2;
                }
                --row;
            }
        } else {
            float tileHeightLowerCorner = (layerTileHeight - layerHexLength) / 2.0f;
            float tileHeightUpperCorner = (layerTileHeight + layerHexLength) / 2.0f;
            float layerTileWidth50 = layerTileWidth * 0.5f;
            int row1 = Math.max(0, (int)((this.viewBounds.y - tileHeightLowerCorner - layerOffsetX) / tileHeightUpperCorner));
            int row2 = Math.min(layerHeight, (int)((this.viewBounds.y + this.viewBounds.height + tileHeightUpperCorner - layerOffsetX) / tileHeightUpperCorner));
            int col1 = Math.max(0, (int)((this.viewBounds.x - layerTileWidth50 - layerOffsetY) / layerTileWidth));
            int col2 = Math.min(layerWidth, (int)((this.viewBounds.x + this.viewBounds.width + layerTileWidth - layerOffsetY) / layerTileWidth));
            float shiftX = 0.0f;
            int row = row2 - 1;
            while (row >= row1) {
                shiftX = row % 2 == 0 == this.staggerIndexEven ? layerTileWidth50 : 0.0f;
                int col = col1;
                while (col < col2) {
                    this.renderCell(layer.getCell(col, row), layerTileWidth * (float)col + shiftX + layerOffsetX, tileHeightUpperCorner * (float)row + layerOffsetY, color);
                    ++col;
                }
                --row;
            }
        }
    }

    private void renderCell(TiledMapTileLayer.Cell cell, float x, float y, float color) {
        TiledMapTile tile;
        if (cell != null && (tile = cell.getTile()) != null) {
            float temp;
            if (tile instanceof AnimatedTiledMapTile) {
                return;
            }
            boolean flipX = cell.getFlipHorizontally();
            boolean flipY = cell.getFlipVertically();
            int rotations = cell.getRotation();
            TextureRegion region = tile.getTextureRegion();
            float x1 = x + tile.getOffsetX() * this.unitScale;
            float y1 = y + tile.getOffsetY() * this.unitScale;
            float x2 = x1 + (float)region.getRegionWidth() * this.unitScale;
            float y2 = y1 + (float)region.getRegionHeight() * this.unitScale;
            float u1 = region.getU();
            float v1 = region.getV2();
            float u2 = region.getU2();
            float v2 = region.getV();
            this.vertices[0] = x1;
            this.vertices[1] = y1;
            this.vertices[2] = color;
            this.vertices[3] = u1;
            this.vertices[4] = v1;
            this.vertices[5] = x1;
            this.vertices[6] = y2;
            this.vertices[7] = color;
            this.vertices[8] = u1;
            this.vertices[9] = v2;
            this.vertices[10] = x2;
            this.vertices[11] = y2;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[15] = x2;
            this.vertices[16] = y1;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v1;
            if (flipX) {
                temp = this.vertices[3];
                this.vertices[3] = this.vertices[13];
                this.vertices[13] = temp;
                temp = this.vertices[8];
                this.vertices[8] = this.vertices[18];
                this.vertices[18] = temp;
            }
            if (flipY) {
                temp = this.vertices[4];
                this.vertices[4] = this.vertices[14];
                this.vertices[14] = temp;
                temp = this.vertices[9];
                this.vertices[9] = this.vertices[19];
                this.vertices[19] = temp;
            }
            if (rotations == 2) {
                float tempU = this.vertices[3];
                this.vertices[3] = this.vertices[13];
                this.vertices[13] = tempU;
                tempU = this.vertices[8];
                this.vertices[8] = this.vertices[18];
                this.vertices[18] = tempU;
                float tempV = this.vertices[4];
                this.vertices[4] = this.vertices[14];
                this.vertices[14] = tempV;
                tempV = this.vertices[9];
                this.vertices[9] = this.vertices[19];
                this.vertices[19] = tempV;
            }
            this.batch.draw(region.getTexture(), this.vertices, 0, 20);
        }
    }
}

