/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ShortArray;

public class ConvexHull {
    private final IntArray quicksortStack = new IntArray();
    private float[] sortedPoints;
    private final FloatArray hull = new FloatArray();
    private final IntArray indices = new IntArray();
    private final ShortArray originalIndices = new ShortArray(false, 0);

    public FloatArray computePolygon(FloatArray points, boolean sorted) {
        return this.computePolygon(points.items, 0, points.size, sorted);
    }

    public FloatArray computePolygon(float[] polygon, boolean sorted) {
        return this.computePolygon(polygon, 0, polygon.length, sorted);
    }

    public FloatArray computePolygon(float[] points, int offset, int count, boolean sorted) {
        int end = offset + count;
        if (!sorted) {
            if (this.sortedPoints == null || this.sortedPoints.length < count) {
                this.sortedPoints = new float[count];
            }
            System.arraycopy(points, offset, this.sortedPoints, 0, count);
            points = this.sortedPoints;
            offset = 0;
            this.sort(points, count);
        }
        FloatArray hull = this.hull;
        hull.clear();
        int i = offset;
        while (i < end) {
            float x = points[i];
            float y = points[i + 1];
            while (hull.size >= 4 && this.ccw(x, y) <= 0.0f) {
                hull.size -= 2;
            }
            hull.add(x);
            hull.add(y);
            i += 2;
        }
        i = end - 4;
        int t = hull.size + 2;
        while (i >= offset) {
            float x = points[i];
            float y = points[i + 1];
            while (hull.size >= t && this.ccw(x, y) <= 0.0f) {
                hull.size -= 2;
            }
            hull.add(x);
            hull.add(y);
            i -= 2;
        }
        return hull;
    }

    public IntArray computeIndices(FloatArray points, boolean sorted, boolean yDown) {
        return this.computeIndices(points.items, 0, points.size, sorted, yDown);
    }

    public IntArray computeIndices(float[] polygon, boolean sorted, boolean yDown) {
        return this.computeIndices(polygon, 0, polygon.length, sorted, yDown);
    }

    public IntArray computeIndices(float[] points, int offset, int count, boolean sorted, boolean yDown) {
        if (count > Short.MAX_VALUE) {
            throw new IllegalArgumentException("count must be <= 32767");
        }
        int end = offset + count;
        if (!sorted) {
            if (this.sortedPoints == null || this.sortedPoints.length < count) {
                this.sortedPoints = new float[count];
            }
            System.arraycopy(points, offset, this.sortedPoints, 0, count);
            points = this.sortedPoints;
            offset = 0;
            this.sortWithIndices(points, count, yDown);
        }
        IntArray indices = this.indices;
        indices.clear();
        FloatArray hull = this.hull;
        hull.clear();
        int i = offset;
        int index = i / 2;
        while (i < end) {
            float x = points[i];
            float y = points[i + 1];
            while (hull.size >= 4 && this.ccw(x, y) <= 0.0f) {
                hull.size -= 2;
                --indices.size;
            }
            hull.add(x);
            hull.add(y);
            indices.add(index);
            i += 2;
            ++index;
        }
        i = end - 4;
        index = i / 2;
        int t = hull.size + 2;
        while (i >= offset) {
            float x = points[i];
            float y = points[i + 1];
            while (hull.size >= t && this.ccw(x, y) <= 0.0f) {
                hull.size -= 2;
                --indices.size;
            }
            hull.add(x);
            hull.add(y);
            indices.add(index);
            i -= 2;
            --index;
        }
        if (!sorted) {
            short[] originalIndicesArray = this.originalIndices.items;
            int[] indicesArray = indices.items;
            int i2 = 0;
            int n = indices.size;
            while (i2 < n) {
                indicesArray[i2] = originalIndicesArray[indicesArray[i2]];
                ++i2;
            }
        }
        return indices;
    }

    private float ccw(float p3x, float p3y) {
        FloatArray hull = this.hull;
        int size = hull.size;
        float p1x = hull.get(size - 4);
        float p1y = hull.get(size - 3);
        float p2x = hull.get(size - 2);
        float p2y = hull.peek();
        return (p2x - p1x) * (p3y - p1y) - (p2y - p1y) * (p3x - p1x);
    }

    private void sort(float[] values, int count) {
        int lower = 0;
        int upper = count - 1;
        IntArray stack = this.quicksortStack;
        stack.add(lower);
        stack.add(upper - 1);
        while (stack.size > 0) {
            upper = stack.pop();
            if (upper <= (lower = stack.pop())) continue;
            int i = this.quicksortPartition(values, lower, upper);
            if (i - lower > upper - i) {
                stack.add(lower);
                stack.add(i - 2);
            }
            stack.add(i + 2);
            stack.add(upper);
            if (upper - i < i - lower) continue;
            stack.add(lower);
            stack.add(i - 2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int quicksortPartition(float[] values, int lower, int upper) {
        x = values[lower];
        y = values[lower + 1];
        up = upper;
        down = lower;
        ** GOTO lbl19
        {
            down += 2;
            do {
                if (down < up && values[down] <= x) continue block0;
                while (values[up] > x || values[up] == x && values[up + 1] < y) {
                    up -= 2;
                }
                if (down >= up) continue;
                temp = values[down];
                values[down] = values[up];
                values[up] = temp;
                temp = values[down + 1];
                values[down + 1] = values[up + 1];
                values[up + 1] = temp;
lbl19:
                // 3 sources

            } while (down < up);
        }
        if (x > values[up] || x == values[up] && y < values[up + 1]) {
            values[lower] = values[up];
            values[up] = x;
            values[lower + 1] = values[up + 1];
            values[up + 1] = y;
        }
        return up;
    }

    private void sortWithIndices(float[] values, int count, boolean yDown) {
        int pointCount = count / 2;
        this.originalIndices.clear();
        this.originalIndices.ensureCapacity(pointCount);
        short[] originalIndicesArray = this.originalIndices.items;
        int i = 0;
        while (i < pointCount) {
            originalIndicesArray[i] = i;
            i = (short)(i + 1);
        }
        int lower = 0;
        int upper = count - 1;
        IntArray stack = this.quicksortStack;
        stack.add(lower);
        stack.add(upper - 1);
        while (stack.size > 0) {
            upper = stack.pop();
            if (upper <= (lower = stack.pop())) continue;
            int i2 = this.quicksortPartitionWithIndices(values, lower, upper, yDown, originalIndicesArray);
            if (i2 - lower > upper - i2) {
                stack.add(lower);
                stack.add(i2 - 2);
            }
            stack.add(i2 + 2);
            stack.add(upper);
            if (upper - i2 < i2 - lower) continue;
            stack.add(lower);
            stack.add(i2 - 2);
        }
    }

    /*
     * Exception decompiling
     */
    private int quicksortPartitionWithIndices(float[] values, int lower, int upper, boolean yDown, short[] originalIndices) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 1[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

