/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;

public class Bone {
    final BoneData data;
    final Skeleton skeleton;
    final Bone parent;
    float x;
    float y;
    float rotation;
    float rotationIK;
    float scaleX;
    float scaleY;
    boolean flipX;
    boolean flipY;
    float m00;
    float m01;
    float worldX;
    float m10;
    float m11;
    float worldY;
    float worldRotation;
    float worldScaleX;
    float worldScaleY;
    boolean worldFlipX;
    boolean worldFlipY;

    Bone(BoneData data) {
        this.data = data;
        this.parent = null;
        this.skeleton = null;
    }

    public Bone(BoneData data, Skeleton skeleton, Bone parent) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = data;
        this.skeleton = skeleton;
        this.parent = parent;
        this.setToSetupPose();
    }

    public Bone(Bone bone, Skeleton skeleton, Bone parent) {
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        this.skeleton = skeleton;
        this.parent = parent;
        this.data = bone.data;
        this.x = bone.x;
        this.y = bone.y;
        this.rotation = bone.rotation;
        this.rotationIK = bone.rotationIK;
        this.scaleX = bone.scaleX;
        this.scaleY = bone.scaleY;
        this.flipX = bone.flipX;
        this.flipY = bone.flipY;
    }

    public void updateWorldTransform() {
        Skeleton skeleton = this.skeleton;
        Bone parent = this.parent;
        float x = this.x;
        float y = this.y;
        if (parent != null) {
            this.worldX = x * parent.m00 + y * parent.m01 + parent.worldX;
            this.worldY = x * parent.m10 + y * parent.m11 + parent.worldY;
            if (this.data.inheritScale) {
                this.worldScaleX = parent.worldScaleX * this.scaleX;
                this.worldScaleY = parent.worldScaleY * this.scaleY;
            } else {
                this.worldScaleX = this.scaleX;
                this.worldScaleY = this.scaleY;
            }
            this.worldRotation = this.data.inheritRotation ? parent.worldRotation + this.rotationIK : this.rotationIK;
            this.worldFlipX = parent.worldFlipX ^ this.flipX;
            this.worldFlipY = parent.worldFlipY ^ this.flipY;
        } else {
            boolean skeletonFlipX = skeleton.flipX;
            boolean skeletonFlipY = skeleton.flipY;
            this.worldX = skeletonFlipX ? -x : x;
            this.worldY = skeletonFlipY ? -y : y;
            this.worldScaleX = this.scaleX;
            this.worldScaleY = this.scaleY;
            this.worldRotation = this.rotationIK;
            this.worldFlipX = skeletonFlipX ^ this.flipX;
            this.worldFlipY = skeletonFlipY ^ this.flipY;
        }
        float cos = MathUtils.cosDeg(this.worldRotation);
        float sin = MathUtils.sinDeg(this.worldRotation);
        if (this.worldFlipX) {
            this.m00 = -cos * this.worldScaleX;
            this.m01 = sin * this.worldScaleY;
        } else {
            this.m00 = cos * this.worldScaleX;
            this.m01 = -sin * this.worldScaleY;
        }
        if (this.worldFlipY) {
            this.m10 = -sin * this.worldScaleX;
            this.m11 = -cos * this.worldScaleY;
        } else {
            this.m10 = sin * this.worldScaleX;
            this.m11 = cos * this.worldScaleY;
        }
    }

    public void setToSetupPose() {
        BoneData data = this.data;
        this.x = data.x;
        this.y = data.y;
        this.rotationIK = this.rotation = data.rotation;
        this.scaleX = data.scaleX;
        this.scaleY = data.scaleY;
        this.flipX = data.flipX;
        this.flipY = data.flipY;
    }

    public BoneData getData() {
        return this.data;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Bone getParent() {
        return this.parent;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getRotationIK() {
        return this.rotationIK;
    }

    public void setRotationIK(float rotationIK) {
        this.rotationIK = rotationIK;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void setScale(float scale) {
        this.scaleX = scale;
        this.scaleY = scale;
    }

    public boolean getFlipX() {
        return this.flipX;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public float getM00() {
        return this.m00;
    }

    public float getM01() {
        return this.m01;
    }

    public float getM10() {
        return this.m10;
    }

    public float getM11() {
        return this.m11;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public float getWorldRotation() {
        return this.worldRotation;
    }

    public float getWorldScaleX() {
        return this.worldScaleX;
    }

    public float getWorldScaleY() {
        return this.worldScaleY;
    }

    public boolean getWorldFlipX() {
        return this.worldFlipX;
    }

    public boolean getWorldFlipY() {
        return this.worldFlipY;
    }

    public Matrix3 getWorldTransform(Matrix3 worldTransform) {
        if (worldTransform == null) {
            throw new IllegalArgumentException("worldTransform cannot be null.");
        }
        float[] val = worldTransform.val;
        val[0] = this.m00;
        val[3] = this.m01;
        val[1] = this.m10;
        val[4] = this.m11;
        val[6] = this.worldX;
        val[7] = this.worldY;
        val[2] = 0.0f;
        val[5] = 0.0f;
        val[8] = 1.0f;
        return worldTransform;
    }

    public Vector2 worldToLocal(Vector2 world) {
        float x = world.x - this.worldX;
        float y = world.y - this.worldY;
        float m00 = this.m00;
        float m10 = this.m10;
        float m01 = this.m01;
        float m11 = this.m11;
        if (this.worldFlipX != this.worldFlipY) {
            m00 = -m00;
            m11 = -m11;
        }
        float invDet = 1.0f / (m00 * m11 - m01 * m10);
        world.x = x * m00 * invDet - y * m01 * invDet;
        world.y = y * m11 * invDet - x * m10 * invDet;
        return world;
    }

    public Vector2 localToWorld(Vector2 local) {
        float x = local.x;
        float y = local.y;
        local.x = x * this.m00 + y * this.m01 + this.worldX;
        local.y = x * this.m10 + y * this.m11 + this.worldY;
        return local;
    }

    public String toString() {
        return this.data.name;
    }
}

