/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBinary;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.SkeletonRendererDebug;
import com.esotericsoftware.spine.Skin;
import java.awt.FileDialog;
import java.io.File;

public class SkeletonViewer
extends ApplicationAdapter {
    static final float checkModifiedInterval = 0.25f;
    static final float reloadDelay = 1.0f;
    UI ui;
    PolygonSpriteBatch batch;
    SkeletonRenderer renderer;
    SkeletonRendererDebug debugRenderer;
    SkeletonData skeletonData;
    Skeleton skeleton;
    AnimationState state;
    int skeletonX;
    int skeletonY;
    FileHandle skeletonFile;
    long lastModified;
    float lastModifiedCheck;
    float reloadTimer;

    @Override
    public void create() {
        this.ui = new UI();
        this.batch = new PolygonSpriteBatch();
        this.renderer = new SkeletonRenderer();
        this.debugRenderer = new SkeletonRendererDebug();
        this.skeletonX = (int)(this.ui.window.getWidth() + ((float)Gdx.graphics.getWidth() - this.ui.window.getWidth()) / 2.0f);
        this.skeletonY = Gdx.graphics.getHeight() / 4;
        this.loadSkeleton(Gdx.files.internal(Gdx.app.getPreferences("spine-skeletontest").getString("lastFile", "spineboy/spineboy.json")), false);
    }

    void loadSkeleton(FileHandle skeletonFile, boolean reload) {
        FileHandle atlasFile;
        if (skeletonFile == null) {
            return;
        }
        Pixmap pixmap = new Pixmap(32, 32, Pixmap.Format.RGBA8888);
        pixmap.setColor(new Color(1.0f, 1.0f, 1.0f, 0.33f));
        pixmap.fill();
        final TextureAtlas.AtlasRegion fake = new TextureAtlas.AtlasRegion(new Texture(pixmap), 0, 0, 32, 32);
        pixmap.dispose();
        String atlasFileName = skeletonFile.nameWithoutExtension();
        if (atlasFileName.endsWith(".json")) {
            atlasFileName = new FileHandle(atlasFileName).nameWithoutExtension();
        }
        if (!(atlasFile = skeletonFile.sibling(String.valueOf(atlasFileName) + ".atlas")).exists()) {
            atlasFile = skeletonFile.sibling(String.valueOf(atlasFileName) + ".atlas.txt");
        }
        TextureAtlas.TextureAtlasData data = !atlasFile.exists() ? new TextureAtlas.TextureAtlasData() : new TextureAtlas.TextureAtlasData(atlasFile, atlasFile.parent(), false);
        TextureAtlas atlas = new TextureAtlas(data){

            @Override
            public TextureAtlas.AtlasRegion findRegion(String name) {
                TextureAtlas.AtlasRegion region = super.findRegion(name);
                return region != null ? region : fake;
            }
        };
        try {
            String extension = skeletonFile.extension();
            if (extension.equalsIgnoreCase("json") || extension.equalsIgnoreCase("txt")) {
                SkeletonJson json = new SkeletonJson(atlas);
                json.setScale(this.ui.scaleSlider.getValue());
                this.skeletonData = json.readSkeletonData(skeletonFile);
            } else {
                SkeletonBinary binary = new SkeletonBinary(atlas);
                binary.setScale(this.ui.scaleSlider.getValue());
                this.skeletonData = binary.readSkeletonData(skeletonFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.ui.toast("Error loading skeleton: " + skeletonFile.name());
            this.lastModifiedCheck = 5.0f;
            return;
        }
        this.skeleton = new Skeleton(this.skeletonData);
        this.skeleton.setToSetupPose();
        this.skeleton = new Skeleton(this.skeleton);
        this.skeleton.updateWorldTransform();
        this.state = new AnimationState(new AnimationStateData(this.skeletonData));
        this.skeletonFile = skeletonFile;
        Preferences prefs = Gdx.app.getPreferences("spine-skeletontest");
        prefs.putString("lastFile", skeletonFile.path());
        prefs.flush();
        this.lastModified = skeletonFile.lastModified();
        this.lastModifiedCheck = 0.25f;
        this.ui.skeletonLabel.setText(skeletonFile.name());
        Array<String> items = new Array<String>();
        for (Skin skin : this.skeletonData.getSkins()) {
            items.add(skin.getName());
        }
        this.ui.skinList.setItems(items);
        items = new Array();
        for (Animation animation : this.skeletonData.getAnimations()) {
            items.add(animation.getName());
        }
        this.ui.animationList.setItems(items);
        this.skeleton.setSkin(this.ui.skinList.getSelected());
        this.state.setAnimation(0, this.ui.animationList.getSelected(), this.ui.loopCheckbox.isChecked());
        if (reload) {
            this.ui.toast("Reloaded.");
        }
    }

    @Override
    public void render() {
        Gdx.gl.glClear(16384);
        float delta = Gdx.graphics.getDeltaTime();
        if (this.skeleton != null) {
            if (this.reloadTimer <= 0.0f) {
                this.lastModifiedCheck -= delta;
                if (this.lastModifiedCheck < 0.0f) {
                    this.lastModifiedCheck = 0.25f;
                    long time = this.skeletonFile.lastModified();
                    if (time != 0L && this.lastModified != time) {
                        this.reloadTimer = 1.0f;
                    }
                }
            } else {
                this.reloadTimer -= delta;
                if (this.reloadTimer <= 0.0f) {
                    this.loadSkeleton(this.skeletonFile, true);
                }
            }
            this.state.getData().setDefaultMix(this.ui.mixSlider.getValue());
            this.renderer.setPremultipliedAlpha(this.ui.premultipliedCheckbox.isChecked());
            delta = Math.min(delta, 0.032f) * this.ui.speedSlider.getValue();
            this.skeleton.update(delta);
            this.skeleton.setFlip(this.ui.flipXCheckbox.isChecked(), this.ui.flipYCheckbox.isChecked());
            if (!this.ui.pauseButton.isChecked()) {
                this.state.update(delta);
                this.state.apply(this.skeleton);
            }
            this.skeleton.setPosition(this.skeletonX, this.skeletonY);
            this.skeleton.updateWorldTransform();
            this.batch.begin();
            this.renderer.draw(this.batch, this.skeleton);
            this.batch.end();
            this.debugRenderer.setBones(this.ui.debugBonesCheckbox.isChecked());
            this.debugRenderer.setRegionAttachments(this.ui.debugRegionsCheckbox.isChecked());
            this.debugRenderer.setBoundingBoxes(this.ui.debugBoundingBoxesCheckbox.isChecked());
            this.debugRenderer.setMeshHull(this.ui.debugMeshHullCheckbox.isChecked());
            this.debugRenderer.setMeshTriangles(this.ui.debugMeshTrianglesCheckbox.isChecked());
            this.debugRenderer.draw(this.skeleton);
        }
        this.ui.stage.act();
        this.ui.stage.draw();
        if (this.state != null) {
            ShapeRenderer shapes = this.debugRenderer.getShapeRenderer();
            AnimationState.TrackEntry entry = this.state.getCurrent(0);
            if (entry != null) {
                float percent = entry.getTime() / entry.getEndTime();
                if (entry.getLoop()) {
                    percent %= 1.0f;
                }
                float x = this.ui.window.getRight() + ((float)Gdx.graphics.getWidth() - this.ui.window.getRight()) * percent;
                shapes.setColor(Color.CYAN);
                shapes.begin(ShapeRenderer.ShapeType.Line);
                shapes.line(x, 0.0f, x, 20.0f);
                shapes.end();
            }
        }
    }

    @Override
    public void resize(int width, int height) {
        this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, width, height);
        this.debugRenderer.getShapeRenderer().setProjectionMatrix(this.batch.getProjectionMatrix());
        this.ui.stage.getViewport().update(width, height, true);
        if (!this.ui.minimizeButton.isChecked()) {
            this.ui.window.setHeight(height);
        }
    }

    public static void main(String[] args) throws Exception {
        LwjglApplicationConfiguration.disableAudio = true;
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.width = 800;
        config.height = 600;
        config.title = "Skeleton Viewer";
        config.allowSoftwareMode = true;
        new LwjglApplication((ApplicationListener)new SkeletonViewer(), config);
    }

    class UI {
        Stage stage = new Stage(new ScreenViewport());
        com.badlogic.gdx.scenes.scene2d.ui.Skin skin = new com.badlogic.gdx.scenes.scene2d.ui.Skin(Gdx.files.internal("skin/skin.json"));
        Window window = new Window("Skeleton", this.skin);
        Table root = new Table(this.skin);
        TextButton browseButton = new TextButton("Browse", this.skin);
        Label skeletonLabel = new Label((CharSequence)"", this.skin);
        List<String> animationList = new List(this.skin);
        List<String> skinList = new List(this.skin);
        CheckBox loopCheckbox = new CheckBox(" Loop", this.skin);
        CheckBox premultipliedCheckbox = new CheckBox(" Premultiplied", this.skin);
        Slider mixSlider = new Slider(0.0f, 2.0f, 0.01f, false, this.skin);
        Label mixLabel = new Label((CharSequence)"0.3", this.skin);
        Slider speedSlider = new Slider(0.1f, 3.0f, 0.01f, false, this.skin);
        Label speedLabel = new Label((CharSequence)"1.0", this.skin);
        CheckBox flipXCheckbox = new CheckBox(" X", this.skin);
        CheckBox flipYCheckbox = new CheckBox(" Y", this.skin);
        CheckBox debugBonesCheckbox = new CheckBox(" Bones", this.skin);
        CheckBox debugRegionsCheckbox = new CheckBox(" Regions", this.skin);
        CheckBox debugBoundingBoxesCheckbox = new CheckBox(" Bounds", this.skin);
        CheckBox debugMeshHullCheckbox = new CheckBox(" Mesh Hull", this.skin);
        CheckBox debugMeshTrianglesCheckbox = new CheckBox(" Mesh Triangles", this.skin);
        Slider scaleSlider = new Slider(0.1f, 3.0f, 0.01f, false, this.skin);
        Label scaleLabel = new Label((CharSequence)"1.0", this.skin);
        TextButton pauseButton = new TextButton("Pause", this.skin, "toggle");
        TextButton minimizeButton = new TextButton("-", this.skin);
        TextButton bonesSetupPoseButton = new TextButton("Bones", this.skin);
        TextButton slotsSetupPoseButton = new TextButton("Slots", this.skin);
        TextButton setupPoseButton = new TextButton("Both", this.skin);
        WidgetGroup toasts = new WidgetGroup();

        public UI() {
            this.premultipliedCheckbox.setChecked(true);
            this.loopCheckbox.setChecked(true);
            this.scaleSlider.setValue(1.0f);
            this.scaleSlider.setSnapToValues(new float[]{1.0f}, 0.1f);
            this.mixSlider.setValue(0.3f);
            this.speedSlider.setValue(1.0f);
            this.speedSlider.setSnapToValues(new float[]{1.0f}, 0.1f);
            this.window.setMovable(false);
            this.window.setResizable(false);
            this.minimizeButton.padTop(-2.0f).padLeft(5.0f);
            this.minimizeButton.getColor().a = 0.66f;
            ScrollPane skinScroll = new ScrollPane(this.skinList, this.skin);
            skinScroll.setFadeScrollBars(false);
            ScrollPane animationScroll = new ScrollPane(this.animationList, this.skin);
            animationScroll.setFadeScrollBars(false);
            this.root.pad(2.0f, 4.0f, 4.0f, 4.0f).defaults().space(6.0f);
            this.root.columnDefaults(0).top().right();
            this.root.columnDefaults(1).left();
            this.root.row().padTop(6.0f);
            this.root.add("Skeleton:");
            Table table = this.table(new Actor[0]);
            table.add(this.skeletonLabel).fillX().expandX();
            table.add(this.browseButton);
            this.root.add(table).fill().row();
            this.root.add("Scale:");
            table = this.table(new Actor[0]);
            table.add(this.scaleLabel).width(29.0f);
            table.add(this.scaleSlider).fillX().expandX();
            this.root.add(table).fill().row();
            this.root.add("Flip:");
            this.root.add(this.table(this.flipXCheckbox, this.flipYCheckbox)).row();
            this.root.add("Debug:");
            this.root.add(this.table(this.debugBonesCheckbox, this.debugRegionsCheckbox, this.debugBoundingBoxesCheckbox)).row();
            this.root.add();
            this.root.add(this.table(this.debugMeshHullCheckbox, this.debugMeshTrianglesCheckbox)).row();
            this.root.add("Alpha:");
            this.root.add(this.premultipliedCheckbox).row();
            this.root.add("Skin:");
            this.root.add(skinScroll).expand().fill().minHeight(75.0f).row();
            this.root.add("Setup Pose:");
            this.root.add(this.table(this.bonesSetupPoseButton, this.slotsSetupPoseButton, this.setupPoseButton)).row();
            this.root.add("Animation:");
            this.root.add(animationScroll).expand().fill().minHeight(75.0f).row();
            this.root.add("Mix:");
            table = this.table(new Actor[0]);
            table.add(this.mixLabel).width(29.0f);
            table.add(this.mixSlider).fillX().expandX();
            this.root.add(table).fill().row();
            this.root.add("Speed:");
            table = this.table(new Actor[0]);
            table.add(this.speedLabel).width(29.0f);
            table.add(this.speedSlider).fillX().expandX();
            this.root.add(table).fill().row();
            this.root.add("Playback:");
            this.root.add(this.table(this.pauseButton, this.loopCheckbox)).row();
            this.window.add(this.root).expand().fill();
            this.window.pack();
            this.stage.addActor(this.window);
            table = new Table(this.skin);
            table.setFillParent(true);
            table.setTouchable(Touchable.disabled);
            this.stage.addActor(table);
            table.pad(10.0f).bottom().right();
            table.add(this.toasts);
            table.debug();
            this.window.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    event.cancel();
                    return true;
                }
            });
            this.browseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    FileDialog fileDialog = new FileDialog(null, "Choose skeleton file");
                    fileDialog.setMode(0);
                    fileDialog.setVisible(true);
                    String name = fileDialog.getFile();
                    String dir = fileDialog.getDirectory();
                    if (name == null || dir == null) {
                        return;
                    }
                    SkeletonViewer.this.loadSkeleton(new FileHandle(new File(dir, name).getAbsolutePath()), false);
                }
            });
            this.setupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((UI)UI.this).SkeletonViewer.this.skeleton != null) {
                        ((UI)UI.this).SkeletonViewer.this.skeleton.setToSetupPose();
                    }
                }
            });
            this.bonesSetupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((UI)UI.this).SkeletonViewer.this.skeleton != null) {
                        ((UI)UI.this).SkeletonViewer.this.skeleton.setBonesToSetupPose();
                    }
                }
            });
            this.slotsSetupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((UI)UI.this).SkeletonViewer.this.skeleton != null) {
                        ((UI)UI.this).SkeletonViewer.this.skeleton.setSlotsToSetupPose();
                    }
                }
            });
            this.minimizeButton.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    event.cancel();
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (UI.this.minimizeButton.isChecked()) {
                        UI.this.window.getCells().get(0).setActor(null);
                        UI.this.window.setHeight(20.0f);
                        UI.this.minimizeButton.setText("+");
                    } else {
                        UI.this.window.getCells().get(0).setActor(UI.this.root);
                        ((UI)UI.this).SkeletonViewer.this.ui.window.setHeight(Gdx.graphics.getHeight());
                        UI.this.minimizeButton.setText("-");
                    }
                }
            });
            this.scaleSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    UI.this.scaleLabel.setText(Float.toString((float)((int)(UI.this.scaleSlider.getValue() * 100.0f)) / 100.0f));
                    if (!UI.this.scaleSlider.isDragging()) {
                        SkeletonViewer.this.loadSkeleton(((UI)UI.this).SkeletonViewer.this.skeletonFile, false);
                    }
                }
            });
            this.speedSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    UI.this.speedLabel.setText(Float.toString((float)((int)(UI.this.speedSlider.getValue() * 100.0f)) / 100.0f));
                }
            });
            this.mixSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    UI.this.mixLabel.setText(Float.toString((float)((int)(UI.this.mixSlider.getValue() * 100.0f)) / 100.0f));
                    if (((UI)UI.this).SkeletonViewer.this.state != null) {
                        ((UI)UI.this).SkeletonViewer.this.state.getData().setDefaultMix(UI.this.mixSlider.getValue());
                    }
                }
            });
            this.animationList.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((UI)UI.this).SkeletonViewer.this.state != null) {
                        ((UI)UI.this).SkeletonViewer.this.state.setAnimation(0, UI.this.animationList.getSelected(), UI.this.loopCheckbox.isChecked());
                    }
                }
            });
            this.skinList.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((UI)UI.this).SkeletonViewer.this.skeleton != null) {
                        ((UI)UI.this).SkeletonViewer.this.skeleton.setSkin(UI.this.skinList.getSelected());
                        ((UI)UI.this).SkeletonViewer.this.skeleton.setSlotsToSetupPose();
                    }
                }
            });
            Gdx.input.setInputProcessor(new InputMultiplexer(this.stage, new InputAdapter(){

                @Override
                public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                    this.touchDragged(screenX, screenY, pointer);
                    return false;
                }

                @Override
                public boolean touchDragged(int screenX, int screenY, int pointer) {
                    ((UI)UI.this).SkeletonViewer.this.skeletonX = screenX;
                    ((UI)UI.this).SkeletonViewer.this.skeletonY = Gdx.graphics.getHeight() - screenY;
                    return false;
                }
            }));
        }

        private Table table(Actor ... actors) {
            Table table = new Table();
            table.defaults().space(6.0f);
            table.add(actors);
            return table;
        }

        void toast(String text) {
            Table table = new Table();
            table.add(new Label((CharSequence)text, this.skin));
            table.getColor().a = 0.0f;
            table.pack();
            table.setPosition(-table.getWidth(), -3.0f - table.getHeight());
            table.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.moveBy(0.0f, table.getHeight(), 0.3f), (Action)Actions.fadeIn(0.3f)), (Action)Actions.delay(5.0f), (Action)Actions.parallel((Action)Actions.moveBy(0.0f, table.getHeight(), 0.3f), (Action)Actions.fadeOut(0.3f)), (Action)Actions.removeActor()));
            for (Actor actor : this.toasts.getChildren()) {
                actor.addAction(Actions.moveBy(0.0f, table.getHeight(), 0.3f));
            }
            this.toasts.addActor(table);
            this.toasts.getParent().toFront();
        }
    }
}

