/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class MeshAttachment
extends Attachment {
    private TextureRegion region;
    private String path;
    private float[] vertices;
    private float[] regionUVs;
    private short[] triangles;
    private float[] worldVertices;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private int hullLength;
    private int[] edges;
    private float width;
    private float height;

    public MeshAttachment(String name) {
        super(name);
    }

    public void setRegion(TextureRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = region;
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public void updateUVs() {
        float width;
        float height;
        float u;
        float v;
        int verticesLength = this.vertices.length;
        int worldVerticesLength = verticesLength / 2 * 5;
        if (this.worldVertices == null || this.worldVertices.length != worldVerticesLength) {
            this.worldVertices = new float[worldVerticesLength];
        }
        if (this.region == null) {
            v = 0.0f;
            u = 0.0f;
            height = 1.0f;
            width = 1.0f;
        } else {
            u = this.region.getU();
            v = this.region.getV();
            width = this.region.getU2() - u;
            height = this.region.getV2() - v;
        }
        float[] regionUVs = this.regionUVs;
        if (this.region instanceof TextureAtlas.AtlasRegion && ((TextureAtlas.AtlasRegion)this.region).rotate) {
            int i = 0;
            int w = 3;
            while (i < verticesLength) {
                this.worldVertices[w] = u + regionUVs[i + 1] * width;
                this.worldVertices[w + 1] = v + height - regionUVs[i] * height;
                i += 2;
                w += 5;
            }
        } else {
            int i = 0;
            int w = 3;
            while (i < verticesLength) {
                this.worldVertices[w] = u + regionUVs[i] * width;
                this.worldVertices[w + 1] = v + regionUVs[i + 1] * height;
                i += 2;
                w += 5;
            }
        }
    }

    public void updateWorldVertices(Slot slot, boolean premultipliedAlpha) {
        Skeleton skeleton = slot.getSkeleton();
        Color skeletonColor = skeleton.getColor();
        Color slotColor = slot.getColor();
        Color meshColor = this.color;
        float a = skeletonColor.a * slotColor.a * meshColor.a * 255.0f;
        float multiplier = premultipliedAlpha ? a : 255.0f;
        float color = NumberUtils.intToFloatColor((int)a << 24 | (int)(skeletonColor.b * slotColor.b * meshColor.b * multiplier) << 16 | (int)(skeletonColor.g * slotColor.g * meshColor.g * multiplier) << 8 | (int)(skeletonColor.r * slotColor.r * meshColor.r * multiplier));
        float[] worldVertices = this.worldVertices;
        FloatArray slotVertices = slot.getAttachmentVertices();
        float[] vertices = this.vertices;
        if (slotVertices.size == vertices.length) {
            vertices = slotVertices.items;
        }
        Bone bone = slot.getBone();
        float x = skeleton.getX() + bone.getWorldX();
        float y = skeleton.getY() + bone.getWorldY();
        float m00 = bone.getM00();
        float m01 = bone.getM01();
        float m10 = bone.getM10();
        float m11 = bone.getM11();
        int v = 0;
        int w = 0;
        int n = worldVertices.length;
        while (w < n) {
            float vx = vertices[v];
            float vy = vertices[v + 1];
            worldVertices[w] = vx * m00 + vy * m01 + x;
            worldVertices[w + 1] = vx * m10 + vy * m11 + y;
            worldVertices[w + 2] = color;
            v += 2;
            w += 5;
        }
    }

    public float[] getWorldVertices() {
        return this.worldVertices;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void setVertices(float[] vertices) {
        this.vertices = vertices;
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public void setTriangles(short[] triangles) {
        this.triangles = triangles;
    }

    public float[] getRegionUVs() {
        return this.regionUVs;
    }

    public void setRegionUVs(float[] regionUVs) {
        this.regionUVs = regionUVs;
    }

    public Color getColor() {
        return this.color;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getHullLength() {
        return this.hullLength;
    }

    public void setHullLength(int hullLength) {
        this.hullLength = hullLength;
    }

    public int[] getEdges() {
        return this.edges;
    }

    public void setEdges(int[] edges) {
        this.edges = edges;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }
}

