/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;

public class SkeletonMeshRenderer
extends SkeletonRenderer<PolygonSpriteBatch> {
    private static final short[] quadTriangles = new short[]{0, 1, 2, 2, 3, 0};

    @Override
    public void draw(PolygonSpriteBatch polygonSpriteBatch, Skeleton skeleton) {
        boolean bl = this.premultipliedAlpha;
        Object object = null;
        float[] fArray = null;
        short[] sArray = null;
        Array<Slot> array = skeleton.drawOrder;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Object object2;
            Slot slot = array.get(i);
            Attachment attachment = slot.attachment;
            Texture texture = null;
            if (attachment instanceof RegionAttachment) {
                object2 = (RegionAttachment)attachment;
                fArray = ((RegionAttachment)object2).updateWorldVertices(slot, bl);
                sArray = quadTriangles;
                texture = ((RegionAttachment)object2).getRegion().getTexture();
            } else if (attachment instanceof MeshAttachment) {
                object2 = (MeshAttachment)attachment;
                fArray = ((MeshAttachment)object2).updateWorldVertices(slot, bl);
                sArray = ((MeshAttachment)object2).getTriangles();
                texture = ((MeshAttachment)object2).getRegion().getTexture();
            } else if (attachment instanceof SkeletonAttachment) {
                object2 = ((SkeletonAttachment)attachment).getSkeleton();
                if (object2 == null) continue;
                Bone bone = slot.getBone();
                Bone bone2 = ((Skeleton)object2).getRootBone();
                float f = bone2.getScaleX();
                float f2 = bone2.getScaleY();
                float f3 = bone2.getRotation();
                ((Skeleton)object2).setPosition(bone.getWorldX(), bone.getWorldY());
                bone2.setRotation(f3 + bone.getWorldRotationX());
                ((Skeleton)object2).updateWorldTransform();
                this.draw(polygonSpriteBatch, (Skeleton)object2);
                ((Skeleton)object2).setPosition(0.0f, 0.0f);
                bone2.setScaleX(f);
                bone2.setScaleY(f2);
                bone2.setRotation(f3);
            }
            if (texture == null) continue;
            object2 = slot.data.getBlendMode();
            if (object2 != object) {
                object = object2;
                polygonSpriteBatch.setBlendFunction(((BlendMode)((Object)object)).getSource(bl), ((BlendMode)((Object)object)).getDest());
            }
            polygonSpriteBatch.draw(texture, fArray, 0, fArray.length, sArray, 0, sArray.length);
        }
    }
}

