/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.utils.TrigUtils;

public class TransformConstraint
implements Constraint {
    final TransformConstraintData data;
    final Array<Bone> bones;
    Bone target;
    float rotateMix;
    float translateMix;
    float scaleMix;
    float shearMix;
    final Vector2 temp = new Vector2();

    public TransformConstraint(TransformConstraintData transformConstraintData, Skeleton skeleton) {
        if (transformConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = transformConstraintData;
        this.rotateMix = transformConstraintData.rotateMix;
        this.translateMix = transformConstraintData.translateMix;
        this.scaleMix = transformConstraintData.scaleMix;
        this.shearMix = transformConstraintData.shearMix;
        this.bones = new Array(transformConstraintData.bones.size);
        for (BoneData boneData : transformConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findBone(transformConstraintData.target.name);
    }

    public TransformConstraint(TransformConstraint transformConstraint, Skeleton skeleton) {
        if (transformConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = transformConstraint.data;
        this.bones = new Array(transformConstraint.bones.size);
        for (Bone bone : transformConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.bones.get(transformConstraint.target.data.index);
        this.rotateMix = transformConstraint.rotateMix;
        this.translateMix = transformConstraint.translateMix;
        this.scaleMix = transformConstraint.scaleMix;
        this.shearMix = transformConstraint.shearMix;
    }

    public void apply() {
        this.update();
    }

    @Override
    public void update() {
        float f = this.rotateMix;
        float f2 = this.translateMix;
        float f3 = this.scaleMix;
        float f4 = this.shearMix;
        Bone bone = this.target;
        float f5 = bone.a;
        float f6 = bone.d;
        float f7 = bone.b;
        float f8 = bone.c;
        float f9 = f5 * f6 - f7 * f8 > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        float f10 = this.data.offsetRotation * f9;
        float f11 = this.data.offsetShearY * f9;
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            float f12;
            float f13;
            float f14;
            float f15;
            float f16;
            Bone bone2 = array.get(i);
            boolean bl = false;
            if (f != 0.0f) {
                f16 = bone2.a;
                f15 = bone2.b;
                f14 = bone2.c;
                f13 = bone2.d;
                f12 = TrigUtils.atan2(f8, f5) - TrigUtils.atan2(f14, f16) + f10;
                if (f12 > (float)Math.PI) {
                    f12 -= (float)Math.PI * 2;
                } else if (f12 < (float)(-Math.PI)) {
                    f12 += (float)Math.PI * 2;
                }
                float f17 = TrigUtils.cos(f12 *= f);
                float f18 = TrigUtils.sin(f12);
                bone2.a = f17 * f16 - f18 * f14;
                bone2.b = f17 * f15 - f18 * f13;
                bone2.c = f18 * f16 + f17 * f14;
                bone2.d = f18 * f15 + f17 * f13;
                bl = true;
            }
            if (f2 != 0.0f) {
                Vector2 vector2 = this.temp;
                bone.localToWorld(vector2.set(this.data.offsetX, this.data.offsetY));
                bone2.worldX += (vector2.x - bone2.worldX) * f2;
                bone2.worldY += (vector2.y - bone2.worldY) * f2;
                bl = true;
            }
            if (f3 > 0.0f) {
                f16 = (float)Math.sqrt(bone2.a * bone2.a + bone2.c * bone2.c);
                f15 = (float)Math.sqrt(f5 * f5 + f8 * f8);
                if (f16 > 1.0E-5f) {
                    f16 = (f16 + (f15 - f16 + this.data.offsetScaleX) * f3) / f16;
                }
                bone2.a *= f16;
                bone2.c *= f16;
                f16 = (float)Math.sqrt(bone2.b * bone2.b + bone2.d * bone2.d);
                f15 = (float)Math.sqrt(f7 * f7 + f6 * f6);
                if (f16 > 1.0E-5f) {
                    f16 = (f16 + (f15 - f16 + this.data.offsetScaleY) * f3) / f16;
                }
                bone2.b *= f16;
                bone2.d *= f16;
                bl = true;
            }
            if (f4 > 0.0f) {
                f16 = bone2.b;
                f15 = bone2.d;
                f14 = TrigUtils.atan2(f15, f16);
                f13 = TrigUtils.atan2(f6, f7) - TrigUtils.atan2(f8, f5) - (f14 - TrigUtils.atan2(bone2.c, bone2.a));
                if (f13 > (float)Math.PI) {
                    f13 -= (float)Math.PI * 2;
                } else if (f13 < (float)(-Math.PI)) {
                    f13 += (float)Math.PI * 2;
                }
                f13 = f14 + (f13 + f11) * f4;
                f12 = (float)Math.sqrt(f16 * f16 + f15 * f15);
                bone2.b = TrigUtils.cos(f13) * f12;
                bone2.d = TrigUtils.sin(f13) * f12;
                bl = true;
            }
            if (!bl) continue;
            bone2.appliedValid = false;
        }
    }

    @Override
    public int getOrder() {
        return this.data.order;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone getTarget() {
        return this.target;
    }

    public void setTarget(Bone bone) {
        this.target = bone;
    }

    public float getRotateMix() {
        return this.rotateMix;
    }

    public void setRotateMix(float f) {
        this.rotateMix = f;
    }

    public float getTranslateMix() {
        return this.translateMix;
    }

    public void setTranslateMix(float f) {
        this.translateMix = f;
    }

    public float getScaleMix() {
        return this.scaleMix;
    }

    public void setScaleMix(float f) {
        this.scaleMix = f;
    }

    public float getShearMix() {
        return this.shearMix;
    }

    public void setShearMix(float f) {
        this.shearMix = f;
    }

    public TransformConstraintData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.name;
    }
}

