/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntSet;
import com.esotericsoftware.spine.Animation$BoneTimeline;
import com.esotericsoftware.spine.Animation$SlotTimeline;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Animation {
    final String name;
    Array<Timeline> timelines;
    final IntSet timelineIDs = new IntSet();
    float duration;

    public Animation(String string, Array<Timeline> array, float f) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = string;
        this.duration = f;
        this.setTimelines(array);
    }

    public void setTimelines(Array<Timeline> array) {
        if (array == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.timelines = array;
        this.timelineIDs.clear();
        for (Timeline timeline : array) {
            this.timelineIDs.add(timeline.getPropertyId());
        }
    }

    public boolean hasTimeline(int n) {
        return this.timelineIDs.contains(n);
    }

    public float getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static int binarySearch(float[] fArray, float f, int n) {
        int n2 = 0;
        int n3 = fArray.length / n - 2;
        if (n3 == 0) {
            return n;
        }
        int n4 = n3 >>> 1;
        while (true) {
            if (fArray[(n4 + 1) * n] <= f) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            if (n2 == n3) {
                return (n2 + 1) * n;
            }
            n4 = n2 + n3 >>> 1;
        }
    }

    static int binarySearch(float[] fArray, float f) {
        int n = 0;
        int n2 = fArray.length - 2;
        if (n2 == 0) {
            return 1;
        }
        int n3 = n2 >>> 1;
        while (true) {
            if (fArray[n3 + 1] <= f) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            if (n == n2) {
                return n + 1;
            }
            n3 = n + n2 >>> 1;
        }
    }

    public static interface Timeline {
        public void apply(Skeleton var1, float var2, float var3, Array<Event> var4, float var5, MixBlend var6, MixDirection var7);

        public int getPropertyId();
    }

    public static enum MixBlend {
        setup,
        first,
        replace,
        add;

    }

    public static enum MixDirection {
        in,
        out;

    }

    public static class PathConstraintMixTimeline
    extends CurveTimeline {
        int pathConstraintIndex;
        private final float[] frames;

        public PathConstraintMixTimeline(int n) {
            super(n);
            this.frames = new float[n * 3];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.pathConstraintMix.ordinal() << 24) + this.pathConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            if (!pathConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        pathConstraint.rotateMix = pathConstraint.data.rotateMix;
                        pathConstraint.translateMix = pathConstraint.data.translateMix;
                        return;
                    }
                    case first: {
                        pathConstraint.rotateMix += (pathConstraint.data.rotateMix - pathConstraint.rotateMix) * f3;
                        pathConstraint.translateMix += (pathConstraint.data.translateMix - pathConstraint.translateMix) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f5 = fArray[fArray.length + -2];
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f6 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f6) / (fArray[n + -3] - f6));
                f5 += (fArray[n + 1] - f5) * f7;
                f4 += (fArray[n + 2] - f4) * f7;
            }
            if (mixBlend == MixBlend.setup) {
                pathConstraint.rotateMix = pathConstraint.data.rotateMix + (f5 - pathConstraint.data.rotateMix) * f3;
                pathConstraint.translateMix = pathConstraint.data.translateMix + (f4 - pathConstraint.data.translateMix) * f3;
            } else {
                pathConstraint.rotateMix += (f5 - pathConstraint.rotateMix) * f3;
                pathConstraint.translateMix += (f4 - pathConstraint.translateMix) * f3;
            }
        }
    }

    public static class PathConstraintSpacingTimeline
    extends PathConstraintPositionTimeline {
        public PathConstraintSpacingTimeline(int n) {
            super(n);
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.pathConstraintSpacing.ordinal() << 24) + this.pathConstraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            if (!pathConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        pathConstraint.spacing = pathConstraint.data.spacing;
                        return;
                    }
                    case first: {
                        pathConstraint.spacing += (pathConstraint.data.spacing - pathConstraint.spacing) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 2]) {
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 2);
                f4 = fArray[n + -1];
                float f5 = fArray[n];
                float f6 = this.getCurvePercent(n / 2 - 1, 1.0f - (f2 - f5) / (fArray[n + -2] - f5));
                f4 += (fArray[n + 1] - f4) * f6;
            }
            pathConstraint.spacing = mixBlend == MixBlend.setup ? pathConstraint.data.spacing + (f4 - pathConstraint.data.spacing) * f3 : (pathConstraint.spacing += (f4 - pathConstraint.spacing) * f3);
        }
    }

    public static class PathConstraintPositionTimeline
    extends CurveTimeline {
        int pathConstraintIndex;
        final float[] frames;

        public PathConstraintPositionTimeline(int n) {
            super(n);
            this.frames = new float[n * 2];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.pathConstraintPosition.ordinal() << 24) + this.pathConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2) {
            this.frames[n *= 2] = f;
            this.frames[n + 1] = f2;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            if (!pathConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        pathConstraint.position = pathConstraint.data.position;
                        return;
                    }
                    case first: {
                        pathConstraint.position += (pathConstraint.data.position - pathConstraint.position) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 2]) {
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 2);
                f4 = fArray[n + -1];
                float f5 = fArray[n];
                float f6 = this.getCurvePercent(n / 2 - 1, 1.0f - (f2 - f5) / (fArray[n + -2] - f5));
                f4 += (fArray[n + 1] - f4) * f6;
            }
            pathConstraint.position = mixBlend == MixBlend.setup ? pathConstraint.data.position + (f4 - pathConstraint.data.position) * f3 : (pathConstraint.position += (f4 - pathConstraint.position) * f3);
        }
    }

    public static class TransformConstraintTimeline
    extends CurveTimeline {
        int transformConstraintIndex;
        private final float[] frames;

        public TransformConstraintTimeline(int n) {
            super(n);
            this.frames = new float[n * 5];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.transformConstraint.ordinal() << 24) + this.transformConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5) {
            this.frames[n *= 5] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            int n;
            TransformConstraint transformConstraint = skeleton.transformConstraints.get(this.transformConstraintIndex);
            if (!transformConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                TransformConstraintData transformConstraintData = transformConstraint.data;
                switch (mixBlend) {
                    case setup: {
                        transformConstraint.rotateMix = transformConstraintData.rotateMix;
                        transformConstraint.translateMix = transformConstraintData.translateMix;
                        transformConstraint.scaleMix = transformConstraintData.scaleMix;
                        transformConstraint.shearMix = transformConstraintData.shearMix;
                        return;
                    }
                    case first: {
                        transformConstraint.rotateMix += (transformConstraintData.rotateMix - transformConstraint.rotateMix) * f3;
                        transformConstraint.translateMix += (transformConstraintData.translateMix - transformConstraint.translateMix) * f3;
                        transformConstraint.scaleMix += (transformConstraintData.scaleMix - transformConstraint.scaleMix) * f3;
                        transformConstraint.shearMix += (transformConstraintData.shearMix - transformConstraint.shearMix) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 5]) {
                n = fArray.length;
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
            } else {
                n = Animation.binarySearch(fArray, f2, 5);
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f8 = fArray[n];
                float f9 = this.getCurvePercent(n / 5 - 1, 1.0f - (f2 - f8) / (fArray[n + -5] - f8));
                f7 += (fArray[n + 1] - f7) * f9;
                f6 += (fArray[n + 2] - f6) * f9;
                f5 += (fArray[n + 3] - f5) * f9;
                f4 += (fArray[n + 4] - f4) * f9;
            }
            if (mixBlend == MixBlend.setup) {
                TransformConstraintData transformConstraintData = transformConstraint.data;
                transformConstraint.rotateMix = transformConstraintData.rotateMix + (f7 - transformConstraintData.rotateMix) * f3;
                transformConstraint.translateMix = transformConstraintData.translateMix + (f6 - transformConstraintData.translateMix) * f3;
                transformConstraint.scaleMix = transformConstraintData.scaleMix + (f5 - transformConstraintData.scaleMix) * f3;
                transformConstraint.shearMix = transformConstraintData.shearMix + (f4 - transformConstraintData.shearMix) * f3;
            } else {
                transformConstraint.rotateMix += (f7 - transformConstraint.rotateMix) * f3;
                transformConstraint.translateMix += (f6 - transformConstraint.translateMix) * f3;
                transformConstraint.scaleMix += (f5 - transformConstraint.scaleMix) * f3;
                transformConstraint.shearMix += (f4 - transformConstraint.shearMix) * f3;
            }
        }
    }

    public static class IkConstraintTimeline
    extends CurveTimeline {
        int ikConstraintIndex;
        private final float[] frames;

        public IkConstraintTimeline(int n) {
            super(n);
            this.frames = new float[n * 6];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.ikConstraint.ordinal() << 24) + this.ikConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3, int n2, boolean bl, boolean bl2) {
            this.frames[n *= 6] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = n2;
            this.frames[n + 4] = bl ? 1.0f : 0.0f;
            this.frames[n + 5] = bl2 ? 1.0f : 0.0f;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            IkConstraint ikConstraint = skeleton.ikConstraints.get(this.ikConstraintIndex);
            if (!ikConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        ikConstraint.mix = ikConstraint.data.mix;
                        ikConstraint.softness = ikConstraint.data.softness;
                        ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                        ikConstraint.compress = ikConstraint.data.compress;
                        ikConstraint.stretch = ikConstraint.data.stretch;
                        return;
                    }
                    case first: {
                        ikConstraint.mix += (ikConstraint.data.mix - ikConstraint.mix) * f3;
                        ikConstraint.softness += (ikConstraint.data.softness - ikConstraint.softness) * f3;
                        ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                        ikConstraint.compress = ikConstraint.data.compress;
                        ikConstraint.stretch = ikConstraint.data.stretch;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 6]) {
                if (mixBlend == MixBlend.setup) {
                    ikConstraint.mix = ikConstraint.data.mix + (fArray[fArray.length + -5] - ikConstraint.data.mix) * f3;
                    ikConstraint.softness = ikConstraint.data.softness + (fArray[fArray.length + -4] - ikConstraint.data.softness) * f3;
                    if (mixDirection == MixDirection.out) {
                        ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                        ikConstraint.compress = ikConstraint.data.compress;
                        ikConstraint.stretch = ikConstraint.data.stretch;
                    } else {
                        ikConstraint.bendDirection = (int)fArray[fArray.length + -3];
                        ikConstraint.compress = fArray[fArray.length + -2] != 0.0f;
                        ikConstraint.stretch = fArray[fArray.length + -1] != 0.0f;
                    }
                } else {
                    ikConstraint.mix += (fArray[fArray.length + -5] - ikConstraint.mix) * f3;
                    ikConstraint.softness += (fArray[fArray.length + -4] - ikConstraint.softness) * f3;
                    if (mixDirection == MixDirection.in) {
                        ikConstraint.bendDirection = (int)fArray[fArray.length + -3];
                        ikConstraint.compress = fArray[fArray.length + -2] != 0.0f;
                        ikConstraint.stretch = fArray[fArray.length + -1] != 0.0f;
                    }
                }
                return;
            }
            int n = Animation.binarySearch(fArray, f2, 6);
            float f4 = fArray[n + -5];
            float f5 = fArray[n + -4];
            float f6 = fArray[n];
            float f7 = this.getCurvePercent(n / 6 - 1, 1.0f - (f2 - f6) / (fArray[n + -6] - f6));
            if (mixBlend == MixBlend.setup) {
                ikConstraint.mix = ikConstraint.data.mix + (f4 + (fArray[n + 1] - f4) * f7 - ikConstraint.data.mix) * f3;
                ikConstraint.softness = ikConstraint.data.softness + (f5 + (fArray[n + 2] - f5) * f7 - ikConstraint.data.softness) * f3;
                if (mixDirection == MixDirection.out) {
                    ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                    ikConstraint.compress = ikConstraint.data.compress;
                    ikConstraint.stretch = ikConstraint.data.stretch;
                } else {
                    ikConstraint.bendDirection = (int)fArray[n + -3];
                    ikConstraint.compress = fArray[n + -2] != 0.0f;
                    ikConstraint.stretch = fArray[n + -1] != 0.0f;
                }
            } else {
                ikConstraint.mix += (f4 + (fArray[n + 1] - f4) * f7 - ikConstraint.mix) * f3;
                ikConstraint.softness += (f5 + (fArray[n + 2] - f5) * f7 - ikConstraint.softness) * f3;
                if (mixDirection == MixDirection.in) {
                    ikConstraint.bendDirection = (int)fArray[n + -3];
                    ikConstraint.compress = fArray[n + -2] != 0.0f;
                    ikConstraint.stretch = fArray[n + -1] != 0.0f;
                }
            }
        }
    }

    public static class DrawOrderTimeline
    implements Timeline {
        private final float[] frames;
        private final int[][] drawOrders;

        public DrawOrderTimeline(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("frameCount must be > 0: " + n);
            }
            this.frames = new float[n];
            this.drawOrders = new int[n][];
        }

        @Override
        public int getPropertyId() {
            return TimelineType.drawOrder.ordinal() << 24;
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, int[] nArray) {
            this.frames[n] = f;
            this.drawOrders[n] = nArray;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Array<Slot> array2 = skeleton.drawOrder;
            Array<Slot> array3 = skeleton.slots;
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    SpineUtils.arraycopy(array3.items, 0, array2.items, 0, array3.size);
                }
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    SpineUtils.arraycopy(array3.items, 0, array2.items, 0, array3.size);
                }
                return;
            }
            int n = f2 >= fArray[fArray.length - 1] ? fArray.length - 1 : Animation.binarySearch(fArray, f2) - 1;
            int[] nArray = this.drawOrders[n];
            if (nArray == null) {
                SpineUtils.arraycopy(array3.items, 0, array2.items, 0, array3.size);
            } else {
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    array2.set(i, array3.get(nArray[i]));
                }
            }
        }
    }

    public static class EventTimeline
    implements Timeline {
        private final float[] frames;
        private final Event[] events;

        public EventTimeline(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("frameCount must be > 0: " + n);
            }
            this.frames = new float[n];
            this.events = new Event[n];
        }

        @Override
        public int getPropertyId() {
            return TimelineType.event.ordinal() << 24;
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, Event event) {
            this.frames[n] = event.time;
            this.events[n] = event;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            int n;
            if (array == null) {
                return;
            }
            float[] fArray = this.frames;
            int n2 = fArray.length;
            if (f > f2) {
                this.apply(skeleton, f, 2.1474836E9f, array, f3, mixBlend, mixDirection);
                f = -1.0f;
            } else if (f >= fArray[n2 - 1]) {
                return;
            }
            if (f2 < fArray[0]) {
                return;
            }
            if (f < fArray[0]) {
                n = 0;
            } else {
                float f4 = fArray[n];
                for (n = Animation.binarySearch(fArray, f); n > 0 && fArray[n - 1] == f4; --n) {
                }
            }
            while (n < n2 && f2 >= fArray[n]) {
                array.add(this.events[n]);
                ++n;
            }
        }
    }

    public static class DeformTimeline
    extends CurveTimeline
    implements Animation$SlotTimeline {
        int slotIndex;
        VertexAttachment attachment;
        private final float[] frames;
        private final float[][] frameVertices;

        public DeformTimeline(int n) {
            super(n);
            this.frames = new float[n];
            this.frameVertices = new float[n][];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.deform.ordinal() << 27) + this.attachment.getId() + this.slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float[] fArray) {
            this.frames[n] = f;
            this.frameVertices[n] = fArray;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            Attachment attachment = slot.attachment;
            if (!(attachment instanceof VertexAttachment) || ((VertexAttachment)attachment).getDeformAttachment() != this.attachment) {
                return;
            }
            FloatArray floatArray = slot.getDeform();
            if (floatArray.size == 0) {
                mixBlend = MixBlend.setup;
            }
            float[][] fArray = this.frameVertices;
            int n = fArray[0].length;
            float[] fArray2 = this.frames;
            if (f2 < fArray2[0]) {
                VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                switch (mixBlend) {
                    case setup: {
                        floatArray.clear();
                        return;
                    }
                    case first: {
                        if (f3 == 1.0f) {
                            floatArray.clear();
                            return;
                        }
                        float[] fArray3 = floatArray.setSize(n);
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray4 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                int n2 = i;
                                fArray3[n2] = fArray3[n2] + (fArray4[i] - fArray3[i]) * f3;
                            }
                        } else {
                            f3 = 1.0f - f3;
                            int n3 = 0;
                            while (n3 < n) {
                                int n4 = n3++;
                                fArray3[n4] = fArray3[n4] * f3;
                            }
                        }
                        break;
                    }
                }
                return;
            }
            float[] fArray5 = floatArray.setSize(n);
            if (f2 >= fArray2[fArray2.length - 1]) {
                float[] fArray6 = fArray[fArray2.length - 1];
                if (f3 == 1.0f) {
                    if (mixBlend == MixBlend.add) {
                        VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray7 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                int n5 = i;
                                fArray5[n5] = fArray5[n5] + (fArray6[i] - fArray7[i]);
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                int n6 = i;
                                fArray5[n6] = fArray5[n6] + fArray6[i];
                            }
                        }
                    } else {
                        SpineUtils.arraycopy(fArray6, 0, fArray5, 0, n);
                    }
                } else {
                    switch (mixBlend) {
                        case setup: {
                            VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] fArray8 = vertexAttachment.getVertices();
                                for (int i = 0; i < n; ++i) {
                                    float f4 = fArray8[i];
                                    fArray5[i] = f4 + (fArray6[i] - f4) * f3;
                                }
                            } else {
                                for (int i = 0; i < n; ++i) {
                                    fArray5[i] = fArray6[i] * f3;
                                }
                            }
                            break;
                        }
                        case first: 
                        case replace: {
                            for (int i = 0; i < n; ++i) {
                                int n7 = i;
                                fArray5[n7] = fArray5[n7] + (fArray6[i] - fArray5[i]) * f3;
                            }
                            break;
                        }
                        case add: {
                            VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] fArray9 = vertexAttachment.getVertices();
                                for (int i = 0; i < n; ++i) {
                                    int n8 = i;
                                    fArray5[n8] = fArray5[n8] + (fArray6[i] - fArray9[i]) * f3;
                                }
                            } else {
                                for (int i = 0; i < n; ++i) {
                                    int n9 = i;
                                    fArray5[n9] = fArray5[n9] + fArray6[i] * f3;
                                }
                            }
                            break;
                        }
                    }
                }
                return;
            }
            int n10 = Animation.binarySearch(fArray2, f2);
            float[] fArray10 = fArray[n10 - 1];
            float[] fArray11 = fArray[n10];
            float f5 = fArray2[n10];
            float f6 = this.getCurvePercent(n10 - 1, 1.0f - (f2 - f5) / (fArray2[n10 - 1] - f5));
            if (f3 == 1.0f) {
                if (mixBlend == MixBlend.add) {
                    VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                    if (vertexAttachment.getBones() == null) {
                        float[] fArray12 = vertexAttachment.getVertices();
                        for (int i = 0; i < n; ++i) {
                            float f7 = fArray10[i];
                            int n11 = i;
                            fArray5[n11] = fArray5[n11] + (f7 + (fArray11[i] - f7) * f6 - fArray12[i]);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            float f8 = fArray10[i];
                            int n12 = i;
                            fArray5[n12] = fArray5[n12] + (f8 + (fArray11[i] - f8) * f6);
                        }
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float f9 = fArray10[i];
                        fArray5[i] = f9 + (fArray11[i] - f9) * f6;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray13 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                float f10 = fArray10[i];
                                float f11 = fArray13[i];
                                fArray5[i] = f11 + (f10 + (fArray11[i] - f10) * f6 - f11) * f3;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                float f12 = fArray10[i];
                                fArray5[i] = (f12 + (fArray11[i] - f12) * f6) * f3;
                            }
                        }
                        break;
                    }
                    case first: 
                    case replace: {
                        for (int i = 0; i < n; ++i) {
                            float f13 = fArray10[i];
                            int n13 = i;
                            fArray5[n13] = fArray5[n13] + (f13 + (fArray11[i] - f13) * f6 - fArray5[i]) * f3;
                        }
                        break;
                    }
                    case add: {
                        VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray14 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                float f14 = fArray10[i];
                                int n14 = i;
                                fArray5[n14] = fArray5[n14] + (f14 + (fArray11[i] - f14) * f6 - fArray14[i]) * f3;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                float f15 = fArray10[i];
                                int n15 = i;
                                fArray5[n15] = fArray5[n15] + (f15 + (fArray11[i] - f15) * f6) * f3;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class AttachmentTimeline
    implements Animation$SlotTimeline {
        int slotIndex;
        final float[] frames;
        final String[] attachmentNames;

        public AttachmentTimeline(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("frameCount must be > 0: " + n);
            }
            this.frames = new float[n];
            this.attachmentNames = new String[n];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.attachment.ordinal() << 24) + this.slotIndex;
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, String string) {
            this.frames[n] = f;
            this.attachmentNames[n] = string;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            int n = f2 >= fArray[fArray.length - 1] ? fArray.length - 1 : Animation.binarySearch(fArray, f2) - 1;
            this.setAttachment(skeleton, slot, this.attachmentNames[n]);
        }

        private void setAttachment(Skeleton skeleton, Slot slot, String string) {
            slot.setAttachment(string == null ? null : skeleton.getAttachment(this.slotIndex, string));
        }
    }

    public static class TwoColorTimeline
    extends CurveTimeline
    implements Animation$SlotTimeline {
        int slotIndex;
        private final float[] frames;

        public TwoColorTimeline(int n) {
            super(n);
            this.frames = new float[n * 8];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.twoColor.ordinal() << 24) + this.slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.frames[n *= 8] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
            this.frames[n + 5] = f6;
            this.frames[n + 6] = f7;
            this.frames[n + 7] = f8;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            int n;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        slot.color.set(slot.data.color);
                        slot.darkColor.set(slot.data.darkColor);
                        return;
                    }
                    case first: {
                        Color color = slot.color;
                        Color color2 = slot.darkColor;
                        Color color3 = slot.data.color;
                        Color color4 = slot.data.darkColor;
                        color.add((color3.r - color.r) * f3, (color3.g - color.g) * f3, (color3.b - color.b) * f3, (color3.a - color.a) * f3);
                        color2.add((color4.r - color2.r) * f3, (color4.g - color2.g) * f3, (color4.b - color2.b) * f3, 0.0f);
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 8]) {
                n = fArray.length;
                f10 = fArray[n + -7];
                f9 = fArray[n + -6];
                f8 = fArray[n + -5];
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
            } else {
                n = Animation.binarySearch(fArray, f2, 8);
                f10 = fArray[n + -7];
                f9 = fArray[n + -6];
                f8 = fArray[n + -5];
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f11 = fArray[n];
                float f12 = this.getCurvePercent(n / 8 - 1, 1.0f - (f2 - f11) / (fArray[n + -8] - f11));
                f10 += (fArray[n + 1] - f10) * f12;
                f9 += (fArray[n + 2] - f9) * f12;
                f8 += (fArray[n + 3] - f8) * f12;
                f7 += (fArray[n + 4] - f7) * f12;
                f6 += (fArray[n + 5] - f6) * f12;
                f5 += (fArray[n + 6] - f5) * f12;
                f4 += (fArray[n + 7] - f4) * f12;
            }
            if (f3 == 1.0f) {
                slot.color.set(f10, f9, f8, f7);
                slot.darkColor.set(f6, f5, f4, 1.0f);
            } else {
                Color color = slot.color;
                Color color5 = slot.darkColor;
                if (mixBlend == MixBlend.setup) {
                    color.set(slot.data.color);
                    color5.set(slot.data.darkColor);
                }
                color.add((f10 - color.r) * f3, (f9 - color.g) * f3, (f8 - color.b) * f3, (f7 - color.a) * f3);
                color5.add((f6 - color5.r) * f3, (f5 - color5.g) * f3, (f4 - color5.b) * f3, 0.0f);
            }
        }
    }

    public static class ColorTimeline
    extends CurveTimeline
    implements Animation$SlotTimeline {
        int slotIndex;
        private final float[] frames;

        public ColorTimeline(int n) {
            super(n);
            this.frames = new float[n * 5];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.color.ordinal() << 24) + this.slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5) {
            this.frames[n *= 5] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            int n;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        slot.color.set(slot.data.color);
                        return;
                    }
                    case first: {
                        Color color = slot.color;
                        Color color2 = slot.data.color;
                        color.add((color2.r - color.r) * f3, (color2.g - color.g) * f3, (color2.b - color.b) * f3, (color2.a - color.a) * f3);
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 5]) {
                n = fArray.length;
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
            } else {
                n = Animation.binarySearch(fArray, f2, 5);
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f8 = fArray[n];
                float f9 = this.getCurvePercent(n / 5 - 1, 1.0f - (f2 - f8) / (fArray[n + -5] - f8));
                f7 += (fArray[n + 1] - f7) * f9;
                f6 += (fArray[n + 2] - f6) * f9;
                f5 += (fArray[n + 3] - f5) * f9;
                f4 += (fArray[n + 4] - f4) * f9;
            }
            if (f3 == 1.0f) {
                slot.color.set(f7, f6, f5, f4);
            } else {
                Color color = slot.color;
                if (mixBlend == MixBlend.setup) {
                    color.set(slot.data.color);
                }
                color.add((f7 - color.r) * f3, (f6 - color.g) * f3, (f5 - color.b) * f3, (f4 - color.a) * f3);
            }
        }
    }

    public static class ShearTimeline
    extends TranslateTimeline {
        public ShearTimeline(int n) {
            super(n);
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.shear.ordinal() << 24) + this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        bone.shearX = bone.data.shearX;
                        bone.shearY = bone.data.shearY;
                        return;
                    }
                    case first: {
                        bone.shearX += (bone.data.shearX - bone.shearX) * f3;
                        bone.shearY += (bone.data.shearY - bone.shearY) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f5 = fArray[fArray.length + -2];
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f6 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f6) / (fArray[n + -3] - f6));
                f5 += (fArray[n + 1] - f5) * f7;
                f4 += (fArray[n + 2] - f4) * f7;
            }
            switch (mixBlend) {
                case setup: {
                    bone.shearX = bone.data.shearX + f5 * f3;
                    bone.shearY = bone.data.shearY + f4 * f3;
                    break;
                }
                case first: 
                case replace: {
                    bone.shearX += (bone.data.shearX + f5 - bone.shearX) * f3;
                    bone.shearY += (bone.data.shearY + f4 - bone.shearY) * f3;
                    break;
                }
                case add: {
                    bone.shearX += f5 * f3;
                    bone.shearY += f4 * f3;
                }
            }
        }
    }

    public static class ScaleTimeline
    extends TranslateTimeline {
        public ScaleTimeline(int n) {
            super(n);
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.scale.ordinal() << 24) + this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        bone.scaleX = bone.data.scaleX;
                        bone.scaleY = bone.data.scaleY;
                        return;
                    }
                    case first: {
                        bone.scaleX += (bone.data.scaleX - bone.scaleX) * f3;
                        bone.scaleY += (bone.data.scaleY - bone.scaleY) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f6 = fArray[fArray.length + -2] * bone.data.scaleX;
                f5 = fArray[fArray.length + -1] * bone.data.scaleY;
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f6 = fArray[n + -2];
                f5 = fArray[n + -1];
                f4 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f4) / (fArray[n + -3] - f4));
                f6 = (f6 + (fArray[n + 1] - f6) * f7) * bone.data.scaleX;
                f5 = (f5 + (fArray[n + 2] - f5) * f7) * bone.data.scaleY;
            }
            if (f3 == 1.0f) {
                if (mixBlend == MixBlend.add) {
                    bone.scaleX += f6 - bone.data.scaleX;
                    bone.scaleY += f5 - bone.data.scaleY;
                } else {
                    bone.scaleX = f6;
                    bone.scaleY = f5;
                }
            } else if (mixDirection == MixDirection.out) {
                switch (mixBlend) {
                    case setup: {
                        float f8 = bone.data.scaleX;
                        f4 = bone.data.scaleY;
                        bone.scaleX = f8 + (Math.abs(f6) * Math.signum(f8) - f8) * f3;
                        bone.scaleY = f4 + (Math.abs(f5) * Math.signum(f4) - f4) * f3;
                        break;
                    }
                    case first: 
                    case replace: {
                        float f9 = bone.scaleX;
                        f4 = bone.scaleY;
                        bone.scaleX = f9 + (Math.abs(f6) * Math.signum(f9) - f9) * f3;
                        bone.scaleY = f4 + (Math.abs(f5) * Math.signum(f4) - f4) * f3;
                        break;
                    }
                    case add: {
                        float f10 = bone.scaleX;
                        f4 = bone.scaleY;
                        bone.scaleX = f10 + (Math.abs(f6) * Math.signum(f10) - bone.data.scaleX) * f3;
                        bone.scaleY = f4 + (Math.abs(f5) * Math.signum(f4) - bone.data.scaleY) * f3;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        float f11 = Math.abs(bone.data.scaleX) * Math.signum(f6);
                        f4 = Math.abs(bone.data.scaleY) * Math.signum(f5);
                        bone.scaleX = f11 + (f6 - f11) * f3;
                        bone.scaleY = f4 + (f5 - f4) * f3;
                        break;
                    }
                    case first: 
                    case replace: {
                        float f12 = Math.abs(bone.scaleX) * Math.signum(f6);
                        f4 = Math.abs(bone.scaleY) * Math.signum(f5);
                        bone.scaleX = f12 + (f6 - f12) * f3;
                        bone.scaleY = f4 + (f5 - f4) * f3;
                        break;
                    }
                    case add: {
                        float f13 = Math.signum(f6);
                        f4 = Math.signum(f5);
                        bone.scaleX = Math.abs(bone.scaleX) * f13 + (f6 - Math.abs(bone.data.scaleX) * f13) * f3;
                        bone.scaleY = Math.abs(bone.scaleY) * f4 + (f5 - Math.abs(bone.data.scaleY) * f4) * f3;
                    }
                }
            }
        }
    }

    public static class TranslateTimeline
    extends CurveTimeline
    implements Animation$BoneTimeline {
        int boneIndex;
        final float[] frames;

        public TranslateTimeline(int n) {
            super(n);
            this.frames = new float[n * 3];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.translate.ordinal() << 24) + this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        bone.x = bone.data.x;
                        bone.y = bone.data.y;
                        return;
                    }
                    case first: {
                        bone.x += (bone.data.x - bone.x) * f3;
                        bone.y += (bone.data.y - bone.y) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f5 = fArray[fArray.length + -2];
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f6 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f6) / (fArray[n + -3] - f6));
                f5 += (fArray[n + 1] - f5) * f7;
                f4 += (fArray[n + 2] - f4) * f7;
            }
            switch (mixBlend) {
                case setup: {
                    bone.x = bone.data.x + f5 * f3;
                    bone.y = bone.data.y + f4 * f3;
                    break;
                }
                case first: 
                case replace: {
                    bone.x += (bone.data.x + f5 - bone.x) * f3;
                    bone.y += (bone.data.y + f4 - bone.y) * f3;
                    break;
                }
                case add: {
                    bone.x += f5 * f3;
                    bone.y += f4 * f3;
                }
            }
        }
    }

    public static class RotateTimeline
    extends CurveTimeline
    implements Animation$BoneTimeline {
        int boneIndex;
        final float[] frames;

        public RotateTimeline(int n) {
            super(n);
            this.frames = new float[n << 1];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.rotate.ordinal() << 24) + this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2) {
            this.frames[n <<= 1] = f;
            this.frames[n + 1] = f2;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        bone.rotation = bone.data.rotation;
                        return;
                    }
                    case first: {
                        float f4 = bone.data.rotation - bone.rotation;
                        bone.rotation += (f4 - (float)((16384 - (int)(16384.499999999996 - (double)(f4 / 360.0f))) * 360)) * f3;
                    }
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 2]) {
                float f5 = fArray[fArray.length + -1];
                switch (mixBlend) {
                    case setup: {
                        bone.rotation = bone.data.rotation + f5 * f3;
                        break;
                    }
                    case first: 
                    case replace: {
                        f5 += bone.data.rotation - bone.rotation;
                        f5 -= (float)((16384 - (int)(16384.499999999996 - (double)(f5 / 360.0f))) * 360);
                    }
                    case add: {
                        bone.rotation += f5 * f3;
                    }
                }
                return;
            }
            int n = Animation.binarySearch(fArray, f2, 2);
            float f6 = fArray[n + -1];
            float f7 = fArray[n];
            float f8 = this.getCurvePercent((n >> 1) - 1, 1.0f - (f2 - f7) / (fArray[n + -2] - f7));
            float f9 = fArray[n + 1] - f6;
            f9 = f6 + (f9 - (float)((16384 - (int)(16384.499999999996 - (double)(f9 / 360.0f))) * 360)) * f8;
            switch (mixBlend) {
                case setup: {
                    bone.rotation = bone.data.rotation + (f9 - (float)((16384 - (int)(16384.499999999996 - (double)(f9 / 360.0f))) * 360)) * f3;
                    break;
                }
                case first: 
                case replace: {
                    f9 += bone.data.rotation - bone.rotation;
                }
                case add: {
                    bone.rotation += (f9 - (float)((16384 - (int)(16384.499999999996 - (double)(f9 / 360.0f))) * 360)) * f3;
                }
            }
        }
    }

    public static abstract class CurveTimeline
    implements Timeline {
        private final float[] curves;

        public CurveTimeline(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("frameCount must be > 0: " + n);
            }
            this.curves = new float[(n - 1) * 19];
        }

        public int getFrameCount() {
            return this.curves.length / 19 + 1;
        }

        public void setStepped(int n) {
            this.curves[n * 19] = 1.0f;
        }

        public void setCurve(int n, float f, float f2, float f3, float f4) {
            float f5 = (-f * 2.0f + f3) * 0.03f;
            float f6 = (-f2 * 2.0f + f4) * 0.03f;
            float f7 = ((f - f3) * 3.0f + 1.0f) * 0.006f;
            float f8 = ((f2 - f4) * 3.0f + 1.0f) * 0.006f;
            float f9 = f5 * 2.0f + f7;
            float f10 = f6 * 2.0f + f8;
            float f11 = f * 0.3f + f5 + f7 * 0.16666667f;
            float f12 = f2 * 0.3f + f6 + f8 * 0.16666667f;
            int n2 = n * 19;
            float[] fArray = this.curves;
            fArray[n2++] = 2.0f;
            float f13 = f11;
            float f14 = f12;
            int n3 = n2 + 19 - 1;
            while (n2 < n3) {
                fArray[n2] = f13;
                fArray[n2 + 1] = f14;
                f13 += (f11 += (f9 += f7));
                f14 += (f12 += (f10 += f8));
                n2 += 2;
            }
        }

        public float getCurvePercent(int n, float f) {
            f = MathUtils.clamp(f, 0.0f, 1.0f);
            float[] fArray = this.curves;
            int n2 = n * 19;
            float f2 = fArray[n2];
            if (f2 == 0.0f) {
                return f;
            }
            if (f2 == 1.0f) {
                return 0.0f;
            }
            float f3 = 0.0f;
            int n3 = ++n2;
            int n4 = n2 + 19 - 1;
            while (n2 < n4) {
                f3 = fArray[n2];
                if (f3 >= f) {
                    if (n2 == n3) {
                        return fArray[n2 + 1] * f / f3;
                    }
                    float f4 = fArray[n2 - 2];
                    float f5 = fArray[n2 - 1];
                    return f5 + (fArray[n2 + 1] - f5) * (f - f4) / (f3 - f4);
                }
                n2 += 2;
            }
            float f6 = fArray[n2 - 1];
            return f6 + (1.0f - f6) * (f - f3) / (1.0f - f3);
        }
    }

    private static enum TimelineType {
        rotate,
        translate,
        scale,
        shear,
        attachment,
        color,
        deform,
        event,
        drawOrder,
        ikConstraint,
        transformConstraint,
        pathConstraintPosition,
        pathConstraintSpacing,
        pathConstraintMix,
        twoColor;

    }
}

