/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import org.lwjgl.input.Mouse;
import org.lwjgl.input.OpenGLPackageAccess;

public class Cursor {
    private final CursorElement[] cursors;
    private int index;
    private boolean destroyed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCapabilities() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (Mouse.getImplementation() != null) {
                return Mouse.getImplementation().getNativeCursorCapabilities();
            }
            return OpenGLPackageAccess.createImplementation().getNativeCursorCapabilities();
        }
    }

    Object getHandle() {
        this.checkValid();
        return this.cursors[this.index].cursorHandle;
    }

    private void checkValid() {
        if (this.destroyed) {
            throw new IllegalStateException("The cursor is destroyed");
        }
    }

    protected void setTimeout() {
        this.checkValid();
        this.cursors[this.index].timeout = System.currentTimeMillis() + this.cursors[this.index].delay;
    }

    protected boolean hasTimedOut() {
        this.checkValid();
        return this.cursors.length > 1 && this.cursors[this.index].timeout < System.currentTimeMillis();
    }

    protected void nextCursor() {
        this.checkValid();
        ++this.index;
        this.index %= this.cursors.length;
    }

    private static class CursorElement {
        final Object cursorHandle;
        final long delay;
        long timeout;
    }
}

