/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.OpenGLPackageAccess;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.InputImplementation;

public class Keyboard {
    private static final String[] keyName = new String[256];
    private static final Map<String, Integer> keyMap = new HashMap<String, Integer>(253);
    private static int counter;
    private static final int keyCount;
    private static boolean created;
    private static boolean repeat_enabled;
    private static final ByteBuffer keyDownBuffer;
    private static ByteBuffer readBuffer;
    private static KeyEvent current_event;
    private static KeyEvent tmp_event;
    private static boolean initialized;
    private static InputImplementation implementation;

    private Keyboard() {
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        Sys.initialize();
        initialized = true;
    }

    private static void create(InputImplementation impl) throws LWJGLException {
        if (created) {
            return;
        }
        if (!initialized) {
            Keyboard.initialize();
        }
        implementation = impl;
        implementation.createKeyboard();
        created = true;
        readBuffer = ByteBuffer.allocate(900);
        Keyboard.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create() throws LWJGLException {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!Display.isCreated()) {
                throw new IllegalStateException("Display must be created.");
            }
            Keyboard.create(OpenGLPackageAccess.createImplementation());
        }
    }

    private static void reset() {
        readBuffer.limit(0);
        for (int i = 0; i < keyDownBuffer.remaining(); ++i) {
            keyDownBuffer.put(i, (byte)0);
        }
        Keyboard.current_event.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCreated() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return created;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!created) {
                return;
            }
            created = false;
            implementation.destroyKeyboard();
            Keyboard.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poll() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            if (!created) {
                throw new IllegalStateException("Keyboard must be created before you can poll the device");
            }
            implementation.pollKeyboard(keyDownBuffer);
            Keyboard.read();
        }
    }

    private static void read() {
        readBuffer.compact();
        implementation.readKeyboard(readBuffer);
        readBuffer.flip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean next() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            boolean result;
            if (!created) {
                throw new IllegalStateException("Keyboard must be created before you can read events");
            }
            while ((result = Keyboard.readNext(current_event)) && current_event.repeat && !repeat_enabled) {
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableRepeatEvents(boolean enable) {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            repeat_enabled = enable;
        }
    }

    private static boolean readNext(KeyEvent event) {
        if (readBuffer.hasRemaining()) {
            event.key = Keyboard.readBuffer.getInt() & 0xFF;
            event.state = Keyboard.readBuffer.get() != 0;
            event.character = Keyboard.readBuffer.getInt();
            event.nanos = Keyboard.readBuffer.getLong();
            event.repeat = Keyboard.readBuffer.get() == 1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getEventCharacter() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return (char)current_event.character;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEventKey() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return current_event.key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getEventKeyState() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return current_event.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getEventNanoseconds() {
        Object object = OpenGLPackageAccess.global_lock;
        synchronized (object) {
            return current_event.nanos;
        }
    }

    static {
        Field[] fields = Keyboard.class.getFields();
        try {
            for (Field field : fields) {
                String name;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || !field.getName().startsWith("KEY_") || field.getName().endsWith("WIN")) continue;
                int key = field.getInt(null);
                Keyboard.keyName[key] = name = field.getName().substring(4);
                keyMap.put(name, key);
                ++counter;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        keyCount = counter;
        keyDownBuffer = BufferUtils.createByteBuffer(256);
        current_event = new KeyEvent();
        tmp_event = new KeyEvent();
    }

    private static final class KeyEvent {
        private int character;
        private int key;
        private boolean state;
        private long nanos;
        private boolean repeat;

        private KeyEvent() {
        }

        private void reset() {
            this.character = 0;
            this.key = 0;
            this.state = false;
            this.repeat = false;
        }
    }
}

