/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.backends.lwjgl3.audio.OpenALMusic;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALSound;
import com.badlogic.gdx.utils.GdxRuntimeException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.MP3Decoder;
import javazoom.jl.decoder.OutputBuffer;

public class Mp3 {

    public static class Sound
    extends OpenALSound {
    }

    public static class Music
    extends OpenALMusic {
        private Bitstream bitstream;
        private OutputBuffer outputBuffer;
        private MP3Decoder decoder;

        @Override
        public int read(byte[] buffer) {
            try {
                Header header;
                int totalLength;
                int length;
                boolean setup;
                boolean bl = setup = this.bitstream == null;
                if (setup) {
                    this.bitstream = new Bitstream(this.file.read());
                    this.decoder = new MP3Decoder();
                }
                int minRequiredLength = buffer.length - 4608;
                for (totalLength = 0; totalLength <= minRequiredLength && (header = this.bitstream.readFrame()) != null; totalLength += length) {
                    if (setup) {
                        int channels = header.mode() == 3 ? 1 : 2;
                        this.outputBuffer = new OutputBuffer(channels, false);
                        this.decoder.setOutputBuffer(this.outputBuffer);
                        this.setup(channels, header.getSampleRate());
                        setup = false;
                    }
                    try {
                        this.decoder.decodeFrame(header, this.bitstream);
                    }
                    catch (Exception channels) {
                        // empty catch block
                    }
                    this.bitstream.closeFrame();
                    length = this.outputBuffer.reset();
                    System.arraycopy(this.outputBuffer.getBuffer(), 0, buffer, totalLength, length);
                }
                return totalLength;
            }
            catch (Throwable ex) {
                this.reset();
                throw new GdxRuntimeException("Error reading audio data.", ex);
            }
        }

        @Override
        public void reset() {
            if (this.bitstream == null) {
                return;
            }
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
            this.bitstream = null;
        }
    }
}

