/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ShortArray;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SkeletonClipping;
import com.esotericsoftware.spine.utils.TwoColorPolygonBatch;

public class SkeletonRenderer {
    private static final short[] quadTriangles = new short[]{0, 1, 2, 2, 3, 0};
    private boolean pmaColors;
    private boolean pmaBlendModes;
    private final FloatArray vertices = new FloatArray(32);
    private final SkeletonClipping clipper = new SkeletonClipping();

    public void draw(TwoColorPolygonBatch twoColorPolygonBatch, Skeleton skeleton) {
        if (twoColorPolygonBatch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        boolean bl = this.pmaColors;
        boolean bl2 = this.pmaBlendModes;
        twoColorPolygonBatch.setPremultipliedAlpha(bl);
        BlendMode blendMode = null;
        int n = 0;
        float[] fArray = null;
        float[] fArray2 = null;
        short[] sArray = null;
        Color color = null;
        Color color2 = skeleton.color;
        float f = color2.r;
        float f2 = color2.g;
        float f3 = color2.b;
        float f4 = color2.a;
        T[] TArray = skeleton.drawOrder.items;
        int n2 = skeleton.drawOrder.size;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Slot slot = (Slot)TArray[i];
            if (!slot.bone.active) {
                this.clipper.clipEnd(slot);
                continue;
            }
            Texture texture = null;
            int n3 = this.clipper.isClipping() ? 2 : 6;
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                object = (RegionAttachment)attachment;
                n = n3 << 2;
                fArray = this.vertices.items;
                ((RegionAttachment)object).computeWorldVertices(slot, fArray, 0, n3);
                sArray = quadTriangles;
                texture = ((RegionAttachment)object).getRegion().getTexture();
                fArray2 = ((RegionAttachment)object).getUVs();
                color = ((RegionAttachment)object).getColor();
            } else if (attachment instanceof MeshAttachment) {
                object = (MeshAttachment)attachment;
                int n4 = ((VertexAttachment)object).getWorldVerticesLength();
                n = (n4 >> 1) * n3;
                fArray = this.vertices.setSize(n);
                ((MeshAttachment)object).computeWorldVertices(slot, 0, n4, fArray, 0, n3);
                sArray = ((MeshAttachment)object).getTriangles();
                texture = ((MeshAttachment)object).getRegion().getTexture();
                fArray2 = ((MeshAttachment)object).getUVs();
                color = ((MeshAttachment)object).getColor();
            } else {
                if (attachment instanceof ClippingAttachment) {
                    object = (ClippingAttachment)attachment;
                    this.clipper.clipStart(slot, (ClippingAttachment)object);
                    continue;
                }
                if (attachment instanceof SkeletonAttachment && (object = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                    this.draw(twoColorPolygonBatch, (Skeleton)object);
                }
            }
            if (texture != null) {
                float f5;
                object = slot.getColor();
                float f6 = f4 * ((Color)object).a * color.a * 255.0f;
                float f7 = bl ? f6 : 255.0f;
                BlendMode blendMode2 = slot.data.getBlendMode();
                if (blendMode2 != blendMode) {
                    if (blendMode2 == BlendMode.additive && bl) {
                        blendMode2 = BlendMode.normal;
                        f6 = 0.0f;
                    }
                    blendMode = blendMode2;
                    blendMode.apply(twoColorPolygonBatch, bl2);
                }
                float f8 = f * color.r * f7;
                float f9 = f2 * color.g * f7;
                float f10 = f3 * color.b * f7;
                float f11 = NumberUtils.intToFloatColor((int)f6 << 24 | (int)(f10 * ((Color)object).b) << 16 | (int)(f9 * ((Color)object).g) << 8 | (int)(f8 * ((Color)object).r));
                Color color3 = slot.getDarkColor();
                float f12 = f5 = color3 == null ? 0.0f : NumberUtils.intToFloatColor((int)(f10 * color3.b) << 16 | (int)(f9 * color3.g) << 8 | (int)(f8 * color3.r));
                if (this.clipper.isClipping()) {
                    this.clipper.clipTriangles(fArray, n, sArray, sArray.length, fArray2, f11, f5, true);
                    FloatArray floatArray = this.clipper.getClippedVertices();
                    ShortArray shortArray = this.clipper.getClippedTriangles();
                    twoColorPolygonBatch.drawTwoColor(texture, floatArray.items, 0, floatArray.size, shortArray.items, 0, shortArray.size);
                } else {
                    int n5 = 2;
                    int n6 = 0;
                    while (n5 < n) {
                        fArray[n5] = f11;
                        fArray[n5 + 1] = f5;
                        fArray[n5 + 2] = fArray2[n6];
                        fArray[n5 + 3] = fArray2[n6 + 1];
                        n5 += 6;
                        n6 += 2;
                    }
                    twoColorPolygonBatch.drawTwoColor(texture, fArray, 0, n, sArray, 0, sArray.length);
                }
            }
            this.clipper.clipEnd(slot);
        }
        this.clipper.clipEnd();
    }

    public void setPremultipliedAlpha(boolean bl) {
        this.pmaColors = bl;
        this.pmaBlendModes = bl;
    }
}

