/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongMap<V>
implements Iterable<Entry<V>> {
    public int size;
    long[] keyTable;
    V[] valueTable;
    V zeroValue;
    boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    protected int shift;
    protected int mask;

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[tableSize];
        this.valueTable = new Object[tableSize];
    }

    protected int place(long item) {
        return (int)((item ^ item >>> 32) * -7046029254386353131L >>> this.shift);
    }

    private int locateKey(long key) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    public V put(long key, V value) {
        if (key == 0L) {
            V oldValue = this.zeroValue;
            this.zeroValue = value;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    private void putResize(long key, V value) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0L) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public V get(long key) {
        if (key == 0L) {
            return this.hasZeroValue ? (V)this.zeroValue : null;
        }
        int i = this.locateKey(key);
        return i >= 0 ? (V)this.valueTable[i] : null;
    }

    public V get(long key, V defaultValue) {
        if (key == 0L) {
            return this.hasZeroValue ? this.zeroValue : defaultValue;
        }
        int i = this.locateKey(key);
        return i >= 0 ? this.valueTable[i] : defaultValue;
    }

    public V remove(long key) {
        if (key == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V oldValue = this.zeroValue;
            this.zeroValue = null;
            --this.size;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != 0L) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0L;
        valueTable[i] = null;
        --this.size;
        return oldValue;
    }

    private void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        long[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new long[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                long key = oldKeyTable[i];
                if (key == 0L) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public int hashCode() {
        int h = this.size;
        if (this.hasZeroValue && this.zeroValue != null) {
            h += this.zeroValue.hashCode();
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            long key = keyTable[i];
            if (key == 0L) continue;
            h = (int)((long)h + key * 31L);
            V value = valueTable[i];
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongMap)) {
            return false;
        }
        LongMap other = (LongMap)obj;
        if (other.size != this.size) {
            return false;
        }
        if (other.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (other.zeroValue == null ? this.zeroValue != null : !other.zeroValue.equals(this.zeroValue))) {
            return false;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            V value;
            long key = keyTable[i];
            if (key == 0L || !((value = valueTable[i]) == null ? other.get(key, ObjectMap.dummy) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        long key;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0L) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i]);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0L) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Entries<V> entries() {
        return new Entries(this);
    }

    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private final Entry<V> entry = new Entry();

        public Entries(LongMap map) {
            super(map);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            long[] keyTable = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0L;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = keyTable[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }
    }

    private static class MapIterator<V> {
        public boolean hasNext;
        final LongMap<V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(LongMap<V> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            long[] keyTable = this.map.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == 0L) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
                this.map.zeroValue = null;
            } else {
                long key;
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                long[] keyTable = this.map.keyTable;
                V[] valueTable = this.map.valueTable;
                int mask = this.map.mask;
                int next = i + 1 & mask;
                while ((key = keyTable[next]) != 0L) {
                    int placement = this.map.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        valueTable[i] = valueTable[next];
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0L;
                valueTable[i] = null;
                if (i != this.currentIndex) {
                    --this.nextIndex;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    public static class Entry<V> {
        public long key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

