/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class PhysicsConstraint
implements Updatable {
    final PhysicsConstraintData data;
    public Bone bone;
    float inertia;
    float strength;
    float damping;
    float massInverse;
    float wind;
    float gravity;
    float mix;
    boolean reset = true;
    float ux;
    float uy;
    float cx;
    float cy;
    float tx;
    float ty;
    float xOffset;
    float xVelocity;
    float yOffset;
    float yVelocity;
    float rotateOffset;
    float rotateVelocity;
    float scaleOffset;
    float scaleVelocity;
    boolean active;
    final Skeleton skeleton;
    float remaining;
    float lastTime;

    public PhysicsConstraint(PhysicsConstraintData physicsConstraintData, Skeleton skeleton) {
        if (physicsConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = physicsConstraintData;
        this.skeleton = skeleton;
        this.bone = skeleton.bones.get(physicsConstraintData.bone.index);
        this.inertia = physicsConstraintData.inertia;
        this.strength = physicsConstraintData.strength;
        this.damping = physicsConstraintData.damping;
        this.massInverse = physicsConstraintData.massInverse;
        this.wind = physicsConstraintData.wind;
        this.gravity = physicsConstraintData.gravity;
        this.mix = physicsConstraintData.mix;
    }

    public void reset() {
        this.remaining = 0.0f;
        this.lastTime = this.skeleton.time;
        this.reset = true;
        this.xOffset = 0.0f;
        this.xVelocity = 0.0f;
        this.yOffset = 0.0f;
        this.yVelocity = 0.0f;
        this.rotateOffset = 0.0f;
        this.rotateVelocity = 0.0f;
        this.scaleOffset = 0.0f;
        this.scaleVelocity = 0.0f;
    }

    public void setToSetupPose() {
        PhysicsConstraintData physicsConstraintData = this.data;
        this.inertia = physicsConstraintData.inertia;
        this.strength = physicsConstraintData.strength;
        this.damping = physicsConstraintData.damping;
        this.massInverse = physicsConstraintData.massInverse;
        this.wind = physicsConstraintData.wind;
        this.gravity = physicsConstraintData.gravity;
        this.mix = physicsConstraintData.mix;
    }

    @Override
    public void update(Skeleton.Physics physics) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = this.mix;
        if (f5 == 0.0f) {
            return;
        }
        boolean bl = this.data.x > 0.0f;
        boolean bl2 = this.data.y > 0.0f;
        boolean bl3 = this.data.rotate > 0.0f || this.data.shearX > 0.0f;
        boolean bl4 = this.data.scaleX > 0.0f;
        Bone bone = this.bone;
        float f6 = bone.data.length;
        switch (physics) {
            case none: {
                return;
            }
            case reset: {
                this.reset();
            }
            case update: {
                Skeleton skeleton = this.skeleton;
                f4 = Math.max(skeleton.time - this.lastTime, 0.0f);
                this.remaining += f4;
                this.lastTime = skeleton.time;
                f3 = bone.worldX;
                f2 = bone.worldY;
                if (this.reset) {
                    this.reset = false;
                    this.ux = f3;
                    this.uy = f2;
                } else {
                    float f7;
                    float f8;
                    float f9;
                    float f10;
                    f = this.remaining;
                    float f11 = this.inertia;
                    float f12 = this.data.step;
                    float f13 = skeleton.data.referenceScale;
                    float f14 = -1.0f;
                    float f15 = this.data.limit * f4;
                    float f16 = f15 * Math.abs(skeleton.scaleY);
                    f15 *= Math.abs(skeleton.scaleX);
                    if (bl || bl2) {
                        if (bl) {
                            f10 = (this.ux - f3) * f11;
                            this.xOffset += f10 > f15 ? f15 : (f10 < -f15 ? -f15 : f10);
                            this.ux = f3;
                        }
                        if (bl2) {
                            f10 = (this.uy - f2) * f11;
                            this.yOffset += f10 > f16 ? f16 : (f10 < -f16 ? -f16 : f10);
                            this.uy = f2;
                        }
                        if (f >= f12) {
                            f14 = (float)Math.pow(this.damping, 60.0f * f12);
                            f10 = this.massInverse * f12;
                            f9 = this.strength;
                            f8 = this.wind * f13 * skeleton.scaleX;
                            f7 = this.gravity * f13 * skeleton.scaleY;
                            do {
                                if (bl) {
                                    this.xVelocity += (f8 - this.xOffset * f9) * f10;
                                    this.xOffset += this.xVelocity * f12;
                                    this.xVelocity *= f14;
                                }
                                if (!bl2) continue;
                                this.yVelocity -= (f7 + this.yOffset * f9) * f10;
                                this.yOffset += this.yVelocity * f12;
                                this.yVelocity *= f14;
                            } while ((f -= f12) >= f12);
                        }
                        if (bl) {
                            bone.worldX += this.xOffset * f5 * this.data.x;
                        }
                        if (bl2) {
                            bone.worldY += this.yOffset * f5 * this.data.y;
                        }
                    }
                    if (bl3 || bl4) {
                        float f17;
                        f10 = SpineUtils.atan2(bone.c, bone.a);
                        f7 = 0.0f;
                        float f18 = this.cx - bone.worldX;
                        float f19 = this.cy - bone.worldY;
                        if (f18 > f15) {
                            f18 = f15;
                        } else if (f18 < -f15) {
                            f18 = -f15;
                        }
                        if (f19 > f16) {
                            f19 = f16;
                        } else if (f19 < -f16) {
                            f19 = -f16;
                        }
                        if (bl3) {
                            f7 = (this.data.rotate + this.data.shearX) * f5;
                            f17 = SpineUtils.atan2(f19 + this.ty, f18 + this.tx) - f10 - this.rotateOffset * f7;
                            this.rotateOffset += (f17 - (float)Math.ceil(f17 * 0.15915494f - 0.5f) * ((float)Math.PI * 2)) * f11;
                            f17 = this.rotateOffset * f7 + f10;
                            f9 = SpineUtils.cos(f17);
                            f8 = SpineUtils.sin(f17);
                            if (bl4 && (f17 = f6 * bone.getWorldScaleX()) > 0.0f) {
                                this.scaleOffset += (f18 * f9 + f19 * f8) * f11 / f17;
                            }
                        } else {
                            f9 = SpineUtils.cos(f10);
                            f8 = SpineUtils.sin(f10);
                            f17 = f6 * bone.getWorldScaleX();
                            if (f17 > 0.0f) {
                                this.scaleOffset += (f18 * f9 + f19 * f8) * f11 / f17;
                            }
                        }
                        f = this.remaining;
                        if (f >= f12) {
                            if (f14 == -1.0f) {
                                f14 = (float)Math.pow(this.damping, 60.0f * f12);
                            }
                            f17 = this.massInverse * f12;
                            float f20 = this.strength;
                            float f21 = this.wind;
                            float f22 = this.gravity;
                            float f23 = f6 / f13;
                            while (true) {
                                f -= f12;
                                if (bl4) {
                                    this.scaleVelocity += (f21 * f9 - f22 * f8 - this.scaleOffset * f20) * f17;
                                    this.scaleOffset += this.scaleVelocity * f12;
                                    this.scaleVelocity *= f14;
                                }
                                if (bl3) {
                                    this.rotateVelocity -= ((f21 * f8 + f22 * f9) * f23 + this.rotateOffset * f20) * f17;
                                    this.rotateOffset += this.rotateVelocity * f12;
                                    this.rotateVelocity *= f14;
                                    if (f < f12) break;
                                    float f24 = this.rotateOffset * f7 + f10;
                                    f9 = SpineUtils.cos(f24);
                                    f8 = SpineUtils.sin(f24);
                                    continue;
                                }
                                if (f < f12) break;
                            }
                        }
                    }
                    this.remaining = f;
                }
                this.cx = bone.worldX;
                this.cy = bone.worldY;
                break;
            }
            case pose: {
                if (bl) {
                    bone.worldX += this.xOffset * f5 * this.data.x;
                }
                if (!bl2) break;
                bone.worldY += this.yOffset * f5 * this.data.y;
            }
        }
        if (bl3) {
            float f25 = this.rotateOffset * f5;
            if (this.data.shearX > 0.0f) {
                f = 0.0f;
                if (this.data.rotate > 0.0f) {
                    f = f25 * this.data.rotate;
                    f4 = SpineUtils.sin(f);
                    f3 = SpineUtils.cos(f);
                    f2 = bone.b;
                    bone.b = f3 * f2 - f4 * bone.d;
                    bone.d = f4 * f2 + f3 * bone.d;
                }
                f4 = SpineUtils.sin(f += f25 * this.data.shearX);
                f3 = SpineUtils.cos(f);
                f2 = bone.a;
                bone.a = f3 * f2 - f4 * bone.c;
                bone.c = f4 * f2 + f3 * bone.c;
            } else {
                f4 = SpineUtils.sin(f25 *= this.data.rotate);
                f3 = SpineUtils.cos(f25);
                f2 = bone.a;
                bone.a = f3 * f2 - f4 * bone.c;
                bone.c = f4 * f2 + f3 * bone.c;
                f2 = bone.b;
                bone.b = f3 * f2 - f4 * bone.d;
                bone.d = f4 * f2 + f3 * bone.d;
            }
        }
        if (bl4) {
            float f26 = 1.0f + this.scaleOffset * f5 * this.data.scaleX;
            bone.a *= f26;
            bone.c *= f26;
        }
        if (physics != Skeleton.Physics.pose) {
            this.tx = f6 * bone.a;
            this.ty = f6 * bone.c;
        }
        bone.updateAppliedTransform();
    }

    public String toString() {
        return this.data.name;
    }
}

