/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BoneLocal;
import com.esotericsoftware.spine.Physics;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Update;
import com.esotericsoftware.spine.utils.SpineUtils;

public class BonePose
extends BoneLocal
implements Update {
    Bone bone;
    float a;
    float b;
    float worldX;
    float c;
    float d;
    float worldY;
    int world;
    int local;

    @Override
    public void update(Skeleton skeleton, Physics physics) {
        if (this.world != skeleton.update) {
            this.updateWorldTransform(skeleton);
        }
    }

    public void updateWorldTransform(Skeleton skeleton) {
        if (this.local == skeleton.update) {
            this.updateLocalTransform(skeleton);
        } else {
            this.world = skeleton.update;
        }
        if (this.bone.parent == null) {
            float f = skeleton.scaleX;
            float f2 = skeleton.scaleY;
            float f3 = (this.rotation + this.shearX) * ((float)Math.PI / 180);
            float f4 = (this.rotation + 90.0f + this.shearY) * ((float)Math.PI / 180);
            this.a = SpineUtils.cos(f3) * this.scaleX * f;
            this.b = SpineUtils.cos(f4) * this.scaleY * f;
            this.c = SpineUtils.sin(f3) * this.scaleX * f2;
            this.d = SpineUtils.sin(f4) * this.scaleY * f2;
            this.worldX = this.x * f + skeleton.x;
            this.worldY = this.y * f2 + skeleton.y;
            return;
        }
        BonePose bonePose = (BonePose)this.bone.parent.applied;
        float f = bonePose.a;
        float f5 = bonePose.b;
        float f6 = bonePose.c;
        float f7 = bonePose.d;
        this.worldX = f * this.x + f5 * this.y + bonePose.worldX;
        this.worldY = f6 * this.x + f7 * this.y + bonePose.worldY;
        switch (this.inherit) {
            case normal: {
                float f8 = (this.rotation + this.shearX) * ((float)Math.PI / 180);
                float f9 = (this.rotation + 90.0f + this.shearY) * ((float)Math.PI / 180);
                float f10 = SpineUtils.cos(f8) * this.scaleX;
                float f11 = SpineUtils.cos(f9) * this.scaleY;
                float f12 = SpineUtils.sin(f8) * this.scaleX;
                float f13 = SpineUtils.sin(f9) * this.scaleY;
                this.a = f * f10 + f5 * f12;
                this.b = f * f11 + f5 * f13;
                this.c = f6 * f10 + f7 * f12;
                this.d = f6 * f11 + f7 * f13;
                return;
            }
            case onlyTranslation: {
                float f14 = (this.rotation + this.shearX) * ((float)Math.PI / 180);
                float f15 = (this.rotation + 90.0f + this.shearY) * ((float)Math.PI / 180);
                this.a = SpineUtils.cos(f14) * this.scaleX;
                this.b = SpineUtils.cos(f15) * this.scaleY;
                this.c = SpineUtils.sin(f14) * this.scaleX;
                this.d = SpineUtils.sin(f15) * this.scaleY;
                break;
            }
            case noRotationOrReflection: {
                float f16;
                float f17 = 1.0f / skeleton.scaleX;
                float f18 = 1.0f / skeleton.scaleY;
                float f19 = (f *= f17) * f + (f6 *= f18) * f6;
                if (f19 > 1.0E-4f) {
                    f19 = Math.abs(f * f7 * f18 - f5 * f17 * f6) / f19;
                    f5 = f6 * f19;
                    f7 = f * f19;
                    f16 = SpineUtils.atan2Deg(f6, f);
                } else {
                    f = 0.0f;
                    f6 = 0.0f;
                    f16 = 90.0f - SpineUtils.atan2Deg(f7, f5);
                }
                float f20 = (this.rotation + this.shearX - f16) * ((float)Math.PI / 180);
                float f21 = (this.rotation + this.shearY - f16 + 90.0f) * ((float)Math.PI / 180);
                float f22 = SpineUtils.cos(f20) * this.scaleX;
                float f23 = SpineUtils.cos(f21) * this.scaleY;
                float f24 = SpineUtils.sin(f20) * this.scaleX;
                float f25 = SpineUtils.sin(f21) * this.scaleY;
                this.a = f * f22 - f5 * f24;
                this.b = f * f23 - f5 * f25;
                this.c = f6 * f22 + f7 * f24;
                this.d = f6 * f23 + f7 * f25;
                break;
            }
            case noScale: 
            case noScaleOrReflection: {
                float f26 = this.rotation * ((float)Math.PI / 180);
                float f27 = SpineUtils.cos(f26);
                float f28 = SpineUtils.sin(f26);
                float f29 = (f * f27 + f5 * f28) / skeleton.scaleX;
                float f30 = (f6 * f27 + f7 * f28) / skeleton.scaleY;
                float f31 = (float)Math.sqrt(f29 * f29 + f30 * f30);
                if (f31 > 1.0E-5f) {
                    f31 = 1.0f / f31;
                }
                f29 *= f31;
                f30 *= f31;
                f31 = (float)Math.sqrt(f29 * f29 + f30 * f30);
                if (this.inherit == BoneData.Inherit.noScale && f * f7 - f5 * f6 < 0.0f != (skeleton.scaleX < 0.0f != skeleton.scaleY < 0.0f)) {
                    f31 = -f31;
                }
                f26 = 1.5707964f + SpineUtils.atan2(f30, f29);
                float f32 = SpineUtils.cos(f26) * f31;
                float f33 = SpineUtils.sin(f26) * f31;
                float f34 = this.shearX * ((float)Math.PI / 180);
                float f35 = (90.0f + this.shearY) * ((float)Math.PI / 180);
                float f36 = SpineUtils.cos(f34) * this.scaleX;
                float f37 = SpineUtils.cos(f35) * this.scaleY;
                float f38 = SpineUtils.sin(f34) * this.scaleX;
                float f39 = SpineUtils.sin(f35) * this.scaleY;
                this.a = f29 * f36 + f32 * f38;
                this.b = f29 * f37 + f32 * f39;
                this.c = f30 * f36 + f33 * f38;
                this.d = f30 * f37 + f33 * f39;
            }
        }
        this.a *= skeleton.scaleX;
        this.b *= skeleton.scaleX;
        this.c *= skeleton.scaleY;
        this.d *= skeleton.scaleY;
    }

    public void updateLocalTransform(Skeleton skeleton) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        this.local = 0;
        this.world = skeleton.update;
        if (this.bone.parent == null) {
            this.x = this.worldX - skeleton.x;
            this.y = this.worldY - skeleton.y;
            float f6 = this.a;
            float f7 = this.b;
            float f8 = this.c;
            float f9 = this.d;
            this.rotation = SpineUtils.atan2Deg(f8, f6);
            this.scaleX = (float)Math.sqrt(f6 * f6 + f8 * f8);
            this.scaleY = (float)Math.sqrt(f7 * f7 + f9 * f9);
            this.shearX = 0.0f;
            this.shearY = SpineUtils.atan2Deg(f6 * f7 + f8 * f9, f6 * f9 - f7 * f8);
            return;
        }
        BonePose bonePose = (BonePose)this.bone.parent.applied;
        float f10 = bonePose.a;
        float f11 = bonePose.b;
        float f12 = bonePose.c;
        float f13 = bonePose.d;
        float f14 = 1.0f / (f10 * f13 - f11 * f12);
        float f15 = f13 * f14;
        float f16 = f11 * f14;
        float f17 = f12 * f14;
        float f18 = f10 * f14;
        float f19 = this.worldX - bonePose.worldX;
        float f20 = this.worldY - bonePose.worldY;
        this.x = f19 * f15 - f20 * f16;
        this.y = f20 * f18 - f19 * f17;
        if (this.inherit == BoneData.Inherit.onlyTranslation) {
            f5 = this.a;
            f4 = this.b;
            f3 = this.c;
            f2 = this.d;
        } else {
            switch (this.inherit) {
                case noRotationOrReflection: {
                    f = Math.abs(f10 * f13 - f11 * f12) / (f10 * f10 + f12 * f12);
                    f11 = -f12 * skeleton.scaleX * f / skeleton.scaleY;
                    f13 = f10 * skeleton.scaleY * f / skeleton.scaleX;
                    f14 = 1.0f / (f10 * f13 - f11 * f12);
                    f15 = f13 * f14;
                    f16 = f11 * f14;
                    break;
                }
                case noScale: 
                case noScaleOrReflection: {
                    f = this.rotation * ((float)Math.PI / 180);
                    float f21 = SpineUtils.cos(f);
                    float f22 = SpineUtils.sin(f);
                    f10 = (f10 * f21 + f11 * f22) / skeleton.scaleX;
                    f12 = (f12 * f21 + f13 * f22) / skeleton.scaleY;
                    float f23 = (float)Math.sqrt(f10 * f10 + f12 * f12);
                    if (f23 > 1.0E-5f) {
                        f23 = 1.0f / f23;
                    }
                    f10 *= f23;
                    f12 *= f23;
                    f23 = (float)Math.sqrt(f10 * f10 + f12 * f12);
                    if (this.inherit == BoneData.Inherit.noScale && f14 < 0.0f != (skeleton.scaleX < 0.0f != skeleton.scaleY < 0.0f)) {
                        f23 = -f23;
                    }
                    f = 1.5707964f + SpineUtils.atan2(f12, f10);
                    f11 = SpineUtils.cos(f) * f23;
                    f13 = SpineUtils.sin(f) * f23;
                    f14 = 1.0f / (f10 * f13 - f11 * f12);
                    f15 = f13 * f14;
                    f16 = f11 * f14;
                    f17 = f12 * f14;
                    f18 = f10 * f14;
                }
            }
            f5 = f15 * this.a - f16 * this.c;
            f4 = f15 * this.b - f16 * this.d;
            f3 = f18 * this.c - f17 * this.a;
            f2 = f18 * this.d - f17 * this.b;
        }
        this.shearX = 0.0f;
        this.scaleX = (float)Math.sqrt(f5 * f5 + f3 * f3);
        if (this.scaleX > 1.0E-4f) {
            f = f5 * f2 - f4 * f3;
            this.scaleY = f / this.scaleX;
            this.shearY = -SpineUtils.atan2Deg(f5 * f4 + f3 * f2, f);
            this.rotation = SpineUtils.atan2Deg(f3, f5);
        } else {
            this.scaleX = 0.0f;
            this.scaleY = (float)Math.sqrt(f4 * f4 + f2 * f2);
            this.shearY = 0.0f;
            this.rotation = 90.0f - SpineUtils.atan2Deg(f2, f4);
        }
    }

    public void validateLocalTransform(Skeleton skeleton) {
        if (this.local == skeleton.update) {
            this.updateLocalTransform(skeleton);
        }
    }

    void modifyLocal(Skeleton skeleton) {
        if (this.local == skeleton.update) {
            this.updateLocalTransform(skeleton);
        }
        this.world = 0;
        this.resetWorld(skeleton.update);
    }

    void modifyWorld(int n) {
        this.local = n;
        this.world = n;
        this.resetWorld(n);
    }

    void resetWorld(int n) {
        Bone[] boneArray = (Bone[])this.bone.children.items;
        int n2 = this.bone.children.size;
        for (int i = 0; i < n2; ++i) {
            BonePose bonePose = (BonePose)boneArray[i].applied;
            if (bonePose.world != n) continue;
            bonePose.world = 0;
            bonePose.local = 0;
            bonePose.resetWorld(n);
        }
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getC() {
        return this.c;
    }

    public float getD() {
        return this.d;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public float getWorldScaleX() {
        return (float)Math.sqrt(this.a * this.a + this.c * this.c);
    }

    public String toString() {
        return ((BoneData)this.bone.data).name;
    }
}

