/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PathConstraintPose;
import com.esotericsoftware.spine.Physics;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;
import java.util.Arrays;

public class PathConstraint
extends Constraint<PathConstraint, PathConstraintData, PathConstraintPose> {
    final Array<BonePose> bones;
    Slot slot;
    private final FloatArray spaces = new FloatArray();
    private final FloatArray positions = new FloatArray();
    private final FloatArray world = new FloatArray();
    private final FloatArray curves = new FloatArray();
    private final FloatArray lengths = new FloatArray();
    private final float[] segments = new float[10];

    public PathConstraint(PathConstraintData pathConstraintData, Skeleton skeleton) {
        super(pathConstraintData, new PathConstraintPose(), new PathConstraintPose());
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.bones = new Array(true, pathConstraintData.bones.size, BonePose[]::new);
        for (BoneData boneData : pathConstraintData.bones) {
            this.bones.add((BonePose)((Bone[])skeleton.bones.items)[boneData.index].constrained);
        }
        this.slot = ((Slot[])skeleton.slots.items)[pathConstraintData.slot.index];
    }

    @Override
    public void update(Skeleton skeleton, Physics physics) {
        boolean bl;
        Object object = ((SlotPose)this.slot.applied).attachment;
        if (!(object instanceof PathAttachment)) {
            return;
        }
        PathAttachment pathAttachment = (PathAttachment)object;
        object = (PathConstraintPose)this.applied;
        float f = ((PathConstraintPose)object).mixRotate;
        float f2 = ((PathConstraintPose)object).mixX;
        float f3 = ((PathConstraintPose)object).mixY;
        if (f == 0.0f & f2 == 0.0f & f3 == 0.0f) {
            return;
        }
        PathConstraintData pathConstraintData = (PathConstraintData)this.data;
        boolean bl2 = pathConstraintData.rotateMode == PathConstraintData.RotateMode.tangent;
        boolean bl3 = pathConstraintData.rotateMode == PathConstraintData.RotateMode.chainScale;
        int n = this.bones.size;
        int n2 = bl2 ? n : n + 1;
        BonePose[] bonePoseArray = (BonePose[])this.bones.items;
        float[] fArray = this.spaces.setSize(n2);
        float[] fArray2 = bl3 ? this.lengths.setSize(n) : null;
        float f4 = ((PathConstraintPose)object).spacing;
        switch (pathConstraintData.spacingMode) {
            case percent: {
                float f5;
                float f6;
                int n3;
                if (bl3) {
                    n3 = n2 - 1;
                    for (int i = 0; i < n3; ++i) {
                        BonePose bonePose = bonePoseArray[i];
                        float f7 = ((BoneData)bonePose.bone.data).length;
                        f6 = f7 * bonePose.a;
                        f5 = f7 * bonePose.c;
                        fArray2[i] = (float)Math.sqrt(f6 * f6 + f5 * f5);
                    }
                }
                Arrays.fill(fArray, 1, n2, f4);
                break;
            }
            case proportional: {
                float f8;
                float f9;
                float f5;
                float f6;
                float f10 = 0.0f;
                int n3 = 0;
                int n4 = n2 - 1;
                while (n3 < n4) {
                    BonePose bonePose = bonePoseArray[n3];
                    f6 = ((BoneData)bonePose.bone.data).length;
                    if (f6 < 1.0E-5f) {
                        if (bl3) {
                            fArray2[n3] = 0.0f;
                        }
                        fArray[++n3] = f4;
                        continue;
                    }
                    f5 = f6 * bonePose.a;
                    f9 = f6 * bonePose.c;
                    f8 = (float)Math.sqrt(f5 * f5 + f9 * f9);
                    if (bl3) {
                        fArray2[n3] = f8;
                    }
                    fArray[++n3] = f8;
                    f10 += f8;
                }
                if (!(f10 > 0.0f)) break;
                f10 = (float)n2 / f10 * f4;
                n3 = 1;
                while (n3 < n2) {
                    int n5 = n3++;
                    fArray[n5] = fArray[n5] * f10;
                }
                break;
            }
            default: {
                float f8;
                float f9;
                float f5;
                float f6;
                boolean bl4 = pathConstraintData.spacingMode == PathConstraintData.SpacingMode.length;
                int n3 = 0;
                int n6 = n2 - 1;
                while (n3 < n6) {
                    BonePose bonePose = bonePoseArray[n3];
                    f6 = ((BoneData)bonePose.bone.data).length;
                    if (f6 < 1.0E-5f) {
                        if (bl3) {
                            fArray2[n3] = 0.0f;
                        }
                        fArray[++n3] = f4;
                        continue;
                    }
                    f5 = f6 * bonePose.a;
                    f9 = f6 * bonePose.c;
                    f8 = (float)Math.sqrt(f5 * f5 + f9 * f9);
                    if (bl3) {
                        fArray2[n3] = f8;
                    }
                    fArray[++n3] = (bl4 ? Math.max(0.0f, f6 + f4) : f4) * f8 / f6;
                }
                break block0;
            }
        }
        float[] fArray3 = this.computeWorldPositions(skeleton, pathAttachment, n2, bl2);
        float f11 = fArray3[0];
        float f12 = fArray3[1];
        float f13 = pathConstraintData.offsetRotation;
        if (f13 == 0.0f) {
            bl = pathConstraintData.rotateMode == PathConstraintData.RotateMode.chain;
        } else {
            bl = false;
            BonePose bonePose = (BonePose)this.slot.bone.applied;
            f13 *= bonePose.a * bonePose.d - bonePose.b * bonePose.c > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        }
        int n7 = 0;
        int n8 = 3;
        int n9 = skeleton.update;
        while (n7 < n) {
            float f14;
            float f15;
            BonePose bonePose = bonePoseArray[n7];
            bonePose.worldX += (f11 - bonePose.worldX) * f2;
            bonePose.worldY += (f12 - bonePose.worldY) * f3;
            float f16 = fArray3[n8];
            float f17 = fArray3[n8 + 1];
            float f18 = f16 - f11;
            float f19 = f17 - f12;
            if (bl3 && (f15 = fArray2[n7]) >= 1.0E-5f) {
                f14 = ((float)Math.sqrt(f18 * f18 + f19 * f19) / f15 - 1.0f) * f + 1.0f;
                bonePose.a *= f14;
                bonePose.c *= f14;
            }
            f11 = f16;
            f12 = f17;
            if (f > 0.0f) {
                float f20;
                float f21;
                f15 = bonePose.a;
                f14 = bonePose.b;
                float f22 = bonePose.c;
                float f23 = bonePose.d;
                float f24 = bl2 ? fArray3[n8 - 1] : (fArray[n7 + 1] < 1.0E-5f ? fArray3[n8 + 2] : SpineUtils.atan2(f19, f18));
                f24 -= SpineUtils.atan2(f22, f15);
                if (bl) {
                    f21 = SpineUtils.cos(f24);
                    f20 = SpineUtils.sin(f24);
                    float f25 = ((BoneData)bonePose.bone.data).length;
                    f11 += (f25 * (f21 * f15 - f20 * f22) - f18) * f;
                    f12 += (f25 * (f20 * f15 + f21 * f22) - f19) * f;
                } else {
                    f24 += f13;
                }
                if (f24 > (float)Math.PI) {
                    f24 -= (float)Math.PI * 2;
                } else if (f24 < (float)(-Math.PI)) {
                    f24 += (float)Math.PI * 2;
                }
                f21 = SpineUtils.cos(f24 *= f);
                f20 = SpineUtils.sin(f24);
                bonePose.a = f21 * f15 - f20 * f22;
                bonePose.b = f21 * f14 - f20 * f23;
                bonePose.c = f20 * f15 + f21 * f22;
                bonePose.d = f20 * f14 + f21 * f23;
            }
            bonePose.modifyWorld(n9);
            ++n7;
            n8 += 3;
        }
    }

    /*
     * Unable to fully structure code
     */
    float[] computeWorldPositions(Skeleton var1_1, PathAttachment var2_2, int var3_3, boolean var4_4) {
        block41: {
            var5_5 = this.slot;
            var6_6 = ((PathConstraintPose)this.applied).position;
            var7_7 = this.spaces.items;
            var8_8 = this.positions.setSize(var3_3 * 3 + 2);
            var10_9 = var2_2.getClosed();
            var11_10 = var2_2.getWorldVerticesLength();
            var12_11 = var11_10 / 6;
            var13_12 = -1;
            if (var2_2.getConstantSpeed()) break block41;
            var14_13 = var2_2.getLengths();
            var15_15 = var14_13[var12_11 -= var10_9 != false ? 1 : 2];
            if (((PathConstraintData)this.data).positionMode == PathConstraintData.PositionMode.percent) {
                var6_6 *= var15_15;
            }
            switch (1.$SwitchMap$com$esotericsoftware$spine$PathConstraintData$SpacingMode[((PathConstraintData)this.data).spacingMode.ordinal()]) {
                case 1: {
                    v0 = var15_15;
                    break;
                }
                case 2: {
                    v0 = var15_15 / (float)var3_3;
                    break;
                }
                default: {
                    v0 = 1.0f;
                }
            }
            var16_17 = v0;
            var9_19 = this.world.setSize(8);
            var17_21 = 0;
            var18_23 = 0;
            var19_25 = 0;
            while (var17_21 < var3_3) {
                block42: {
                    var20_27 = var7_7[var17_21] * var16_17;
                    var21_29 = var6_6 += var20_27;
                    if (!var10_9) break block42;
                    if ((var21_29 %= var15_15) < 0.0f) {
                        var21_29 += var15_15;
                    }
                    var19_25 = 0;
                    ** GOTO lbl-1000
                }
                if (var21_29 < 0.0f) {
                    if (var13_12 != -2) {
                        var13_12 = -2;
                        var2_2.computeWorldVertices(var1_1, var5_5, 2, 4, var9_19, 0, 2);
                    }
                    this.addBeforePosition(var21_29, var9_19, 0, var8_8, var18_23);
                } else if (var21_29 > var15_15) {
                    if (var13_12 != -3) {
                        var13_12 = -3;
                        var2_2.computeWorldVertices(var1_1, var5_5, var11_10 - 6, 4, var9_19, 0, 2);
                    }
                    this.addAfterPosition(var21_29 - var15_15, var9_19, 0, var8_8, var18_23);
                } else lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (!(var21_29 > (var22_31 = var14_13[var19_25]))) {
                            if (var19_25 == 0) {
                                var21_29 /= var22_31;
                                break;
                            }
                            var23_33 = var14_13[var19_25 - 1];
                            var21_29 = (var21_29 - var23_33) / (var22_31 - var23_33);
                            break;
                        }
                        ++var19_25;
                    }
                    if (var19_25 != var13_12) {
                        var13_12 = var19_25;
                        if (var10_9 && var19_25 == var12_11) {
                            var2_2.computeWorldVertices(var1_1, var5_5, var11_10 - 4, 4, var9_19, 0, 2);
                            var2_2.computeWorldVertices(var1_1, var5_5, 0, 4, var9_19, 4, 2);
                        } else {
                            var2_2.computeWorldVertices(var1_1, var5_5, var19_25 * 6 + 2, 8, var9_19, 0, 2);
                        }
                    }
                    this.addCurvePosition(var21_29, var9_19[0], var9_19[1], var9_19[2], var9_19[3], var9_19[4], var9_19[5], var9_19[6], var9_19[7], var8_8, var18_23, var4_4 != false || var17_21 > 0 && var20_27 < 1.0E-5f);
                }
                ++var17_21;
                var18_23 += 3;
            }
            return var8_8;
        }
        if (var10_9) {
            var9_20 = this.world.setSize(var11_10 += 2);
            var2_2.computeWorldVertices(var1_1, var5_5, 2, var11_10 - 4, var9_20, 0, 2);
            var2_2.computeWorldVertices(var1_1, var5_5, 0, 2, var9_20, var11_10 - 4, 2);
            var9_20[var11_10 - 2] = var9_20[0];
            var9_20[var11_10 - 1] = var9_20[1];
        } else {
            --var12_11;
            var9_20 = this.world.setSize(var11_10 -= 4);
            var2_2.computeWorldVertices(var1_1, var5_5, 2, var11_10, var9_20, 0, 2);
        }
        var14_14 = this.curves.setSize(var12_11);
        var15_16 = 0.0f;
        var16_18 = var9_20[0];
        var17_22 = var9_20[1];
        var18_24 = 0.0f;
        var19_26 = 0.0f;
        var20_28 = 0.0f;
        var21_30 = 0.0f;
        var22_32 = 0.0f;
        var23_34 = 0.0f;
        var32_35 = 0;
        var33_37 = 2;
        while (var32_35 < var12_11) {
            var18_24 = var9_20[var33_37];
            var19_26 = var9_20[var33_37 + 1];
            var20_28 = var9_20[var33_37 + 2];
            var21_30 = var9_20[var33_37 + 3];
            var22_32 = var9_20[var33_37 + 4];
            var23_34 = var9_20[var33_37 + 5];
            var24_39 = (var16_18 - var18_24 * 2.0f + var20_28) * 0.1875f;
            var25_40 = (var17_22 - var19_26 * 2.0f + var21_30) * 0.1875f;
            var26_41 = ((var18_24 - var20_28) * 3.0f - var16_18 + var22_32) * 0.09375f;
            var27_42 = ((var19_26 - var21_30) * 3.0f - var17_22 + var23_34) * 0.09375f;
            var28_43 = var24_39 * 2.0f + var26_41;
            var29_44 = var25_40 * 2.0f + var27_42;
            var30_45 = (var18_24 - var16_18) * 0.75f + var24_39 + var26_41 * 0.16666667f;
            var31_46 = (var19_26 - var17_22) * 0.75f + var25_40 + var27_42 * 0.16666667f;
            var15_16 += (float)Math.sqrt(var30_45 * var30_45 + var31_46 * var31_46);
            var30_45 += var28_43;
            var31_46 += var29_44;
            var15_16 += (float)Math.sqrt(var30_45 * var30_45 + var31_46 * var31_46);
            var15_16 += (float)Math.sqrt((var30_45 += (var28_43 += var26_41)) * var30_45 + (var31_46 += (var29_44 += var27_42)) * var31_46);
            var14_14[var32_35] = var15_16 += (float)Math.sqrt((var30_45 += var28_43 + var26_41) * var30_45 + (var31_46 += var29_44 + var27_42) * var31_46);
            var16_18 = var22_32;
            var17_22 = var23_34;
            ++var32_35;
            var33_37 += 6;
        }
        if (((PathConstraintData)this.data).positionMode == PathConstraintData.PositionMode.percent) {
            var6_6 *= var15_16;
        }
        switch (1.$SwitchMap$com$esotericsoftware$spine$PathConstraintData$SpacingMode[((PathConstraintData)this.data).spacingMode.ordinal()]) {
            case 1: {
                v1 = var15_16;
                break;
            }
            case 2: {
                v1 = var15_16 / (float)var3_3;
                break;
            }
            default: {
                v1 = 1.0f;
            }
        }
        var32_36 = v1;
        var33_38 = this.segments;
        var34_47 = 0.0f;
        var35_48 = 0;
        var36_49 = 0;
        var37_50 = 0;
        var38_51 = 0;
        while (var35_48 < var3_3) {
            block43: {
                var39_52 = var7_7[var35_48] * var32_36;
                var40_53 = var6_6 += var39_52;
                if (!var10_9) break block43;
                if ((var40_53 %= var15_16) < 0.0f) {
                    var40_53 += var15_16;
                }
                var37_50 = 0;
                var38_51 = 0;
                ** GOTO lbl-1000
            }
            if (var40_53 < 0.0f) {
                this.addBeforePosition(var40_53, var9_20, 0, var8_8, var36_49);
            } else if (var40_53 > var15_16) {
                this.addAfterPosition(var40_53 - var15_16, var9_20, var11_10 - 4, var8_8, var36_49);
            } else lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (!(var40_53 > (var41_54 = var14_14[var37_50]))) {
                        if (var37_50 == 0) {
                            var40_53 /= var41_54;
                            break;
                        }
                        var42_56 = var14_14[var37_50 - 1];
                        var40_53 = (var40_53 - var42_56) / (var41_54 - var42_56);
                        break;
                    }
                    ++var37_50;
                }
                if (var37_50 != var13_12) {
                    var13_12 = var37_50;
                    var41_55 = var37_50 * 6;
                    var16_18 = var9_20[var41_55];
                    var17_22 = var9_20[var41_55 + 1];
                    var18_24 = var9_20[var41_55 + 2];
                    var19_26 = var9_20[var41_55 + 3];
                    var20_28 = var9_20[var41_55 + 4];
                    var21_30 = var9_20[var41_55 + 5];
                    var22_32 = var9_20[var41_55 + 6];
                    var23_34 = var9_20[var41_55 + 7];
                    var24_39 = (var16_18 - var18_24 * 2.0f + var20_28) * 0.03f;
                    var25_40 = (var17_22 - var19_26 * 2.0f + var21_30) * 0.03f;
                    var26_41 = ((var18_24 - var20_28) * 3.0f - var16_18 + var22_32) * 0.006f;
                    var27_42 = ((var19_26 - var21_30) * 3.0f - var17_22 + var23_34) * 0.006f;
                    var28_43 = var24_39 * 2.0f + var26_41;
                    var29_44 = var25_40 * 2.0f + var27_42;
                    var30_45 = (var18_24 - var16_18) * 0.3f + var24_39 + var26_41 * 0.16666667f;
                    var31_46 = (var19_26 - var17_22) * 0.3f + var25_40 + var27_42 * 0.16666667f;
                    var33_38[0] = var34_47 = (float)Math.sqrt(var30_45 * var30_45 + var31_46 * var31_46);
                    for (var41_55 = 1; var41_55 < 8; ++var41_55) {
                        var33_38[var41_55] = var34_47 += (float)Math.sqrt((var30_45 += (var28_43 += var26_41)) * var30_45 + (var31_46 += (var29_44 += var27_42)) * var31_46);
                    }
                    var33_38[8] = var34_47 += (float)Math.sqrt((var30_45 += var28_43) * var30_45 + (var31_46 += var29_44) * var31_46);
                    var33_38[9] = var34_47 += (float)Math.sqrt((var30_45 += var28_43 + var26_41) * var30_45 + (var31_46 += var29_44 + var27_42) * var31_46);
                    var38_51 = 0;
                }
                var40_53 *= var34_47;
                while (true) {
                    if (!(var40_53 > (var41_54 = var33_38[var38_51]))) {
                        if (var38_51 == 0) {
                            var40_53 /= var41_54;
                            break;
                        }
                        var42_56 = var33_38[var38_51 - 1];
                        var40_53 = (float)var38_51 + (var40_53 - var42_56) / (var41_54 - var42_56);
                        break;
                    }
                    ++var38_51;
                }
                this.addCurvePosition(var40_53 * 0.1f, var16_18, var17_22, var18_24, var19_26, var20_28, var21_30, var22_32, var23_34, var8_8, var36_49, var4_4 != false || var35_48 > 0 && var39_52 < 1.0E-5f);
            }
            ++var35_48;
            var36_49 += 3;
        }
        return var8_8;
    }

    private void addBeforePosition(float f, float[] fArray, int n, float[] fArray2, int n2) {
        float f2 = fArray[n];
        float f3 = fArray[n + 1];
        float f4 = fArray[n + 2] - f2;
        float f5 = fArray[n + 3] - f3;
        float f6 = SpineUtils.atan2(f5, f4);
        fArray2[n2] = f2 + f * SpineUtils.cos(f6);
        fArray2[n2 + 1] = f3 + f * SpineUtils.sin(f6);
        fArray2[n2 + 2] = f6;
    }

    private void addAfterPosition(float f, float[] fArray, int n, float[] fArray2, int n2) {
        float f2 = fArray[n + 2];
        float f3 = fArray[n + 3];
        float f4 = f2 - fArray[n];
        float f5 = f3 - fArray[n + 1];
        float f6 = SpineUtils.atan2(f5, f4);
        fArray2[n2] = f2 + f * SpineUtils.cos(f6);
        fArray2[n2 + 1] = f3 + f * SpineUtils.sin(f6);
        fArray2[n2 + 2] = f6;
    }

    private void addCurvePosition(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray, int n, boolean bl) {
        if (f < 1.0E-5f || Float.isNaN(f)) {
            fArray[n] = f2;
            fArray[n + 1] = f3;
            fArray[n + 2] = SpineUtils.atan2(f5 - f3, f4 - f2);
            return;
        }
        float f10 = f * f;
        float f11 = f10 * f;
        float f12 = 1.0f - f;
        float f13 = f12 * f12;
        float f14 = f13 * f12;
        float f15 = f12 * f;
        float f16 = f15 * 3.0f;
        float f17 = f12 * f16;
        float f18 = f16 * f;
        float f19 = f2 * f14 + f4 * f17 + f6 * f18 + f8 * f11;
        float f20 = f3 * f14 + f5 * f17 + f7 * f18 + f9 * f11;
        fArray[n] = f19;
        fArray[n + 1] = f20;
        if (bl) {
            fArray[n + 2] = f < 0.001f ? SpineUtils.atan2(f5 - f3, f4 - f2) : SpineUtils.atan2(f20 - (f3 * f13 + f5 * f15 * 2.0f + f7 * f10), f19 - (f2 * f13 + f4 * f15 * 2.0f + f6 * f10));
        }
    }

    @Override
    void sort(Skeleton skeleton) {
        int n;
        int n2 = ((SlotData)this.slot.getData()).index;
        Bone bone = this.slot.bone;
        if (skeleton.skin != null) {
            this.sortPathSlot(skeleton, skeleton.skin, n2, bone);
        }
        if (skeleton.data.defaultSkin != null && skeleton.data.defaultSkin != skeleton.skin) {
            this.sortPathSlot(skeleton, skeleton.data.defaultSkin, n2, bone);
        }
        this.sortPath(skeleton, ((SlotPose)this.slot.pose).attachment, bone);
        BonePose[] bonePoseArray = (BonePose[])this.bones.items;
        int n3 = this.bones.size;
        for (n = 0; n < n3; ++n) {
            Bone bone2 = bonePoseArray[n].bone;
            skeleton.sortBone(bone2);
            skeleton.constrained(bone2);
        }
        skeleton.updateCache.add(this);
        for (n = 0; n < n3; ++n) {
            skeleton.sortReset(bonePoseArray[n].bone.children);
        }
        for (n = 0; n < n3; ++n) {
            bonePoseArray[n].bone.sorted = true;
        }
    }

    private void sortPathSlot(Skeleton skeleton, Skin skin, int n, Bone bone) {
        T[] TArray = skin.attachments.orderedItems().items;
        int n2 = skin.attachments.size;
        for (int i = 0; i < n2; ++i) {
            Skin.SkinEntry skinEntry = (Skin.SkinEntry)TArray[i];
            if (skinEntry.slotIndex != n) continue;
            this.sortPath(skeleton, skinEntry.attachment, bone);
        }
    }

    private void sortPath(Skeleton skeleton, Attachment attachment, Bone bone) {
        if (!(attachment instanceof PathAttachment)) {
            return;
        }
        PathAttachment pathAttachment = (PathAttachment)attachment;
        int[] nArray = pathAttachment.getBones();
        if (nArray == null) {
            skeleton.sortBone(bone);
        } else {
            Bone[] boneArray = (Bone[])skeleton.bones.items;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int n3 = nArray[n++];
                n3 += n;
                while (n < n3) {
                    skeleton.sortBone(boneArray[nArray[n++]]);
                }
            }
        }
    }

    @Override
    boolean isSourceActive() {
        return this.slot.bone.active;
    }
}

