/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;

public class SkeletonBounds {
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private Array<BoundingBoxAttachment> boundingBoxes = new Array(true, 8, BoundingBoxAttachment[]::new);
    private Array<FloatArray> polygons = new Array(true, 8, FloatArray[]::new);
    private Pool<FloatArray> polygonPool = new Pool(){

        protected Object newObject() {
            return new FloatArray();
        }
    };

    public void update(Skeleton skeleton, boolean bl) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        Array<BoundingBoxAttachment> array = this.boundingBoxes;
        Array<FloatArray> array2 = this.polygons;
        array.clear();
        this.polygonPool.freeAll(array2);
        array2.clear();
        Slot[] slotArray = (Slot[])skeleton.slots.items;
        int n = skeleton.slots.size;
        for (int i = 0; i < n; ++i) {
            Attachment attachment;
            Slot slot = slotArray[i];
            if (!slot.bone.active || !((attachment = ((SlotPose)slot.applied).attachment) instanceof BoundingBoxAttachment)) continue;
            BoundingBoxAttachment boundingBoxAttachment = (BoundingBoxAttachment)attachment;
            array.add(boundingBoxAttachment);
            FloatArray floatArray = this.polygonPool.obtain();
            array2.add(floatArray);
            boundingBoxAttachment.computeWorldVertices(skeleton, slot, 0, boundingBoxAttachment.getWorldVerticesLength(), floatArray.setSize(boundingBoxAttachment.getWorldVerticesLength()), 0, 2);
        }
        if (bl) {
            this.aabbCompute();
        } else {
            this.minX = -2.1474836E9f;
            this.minY = -2.1474836E9f;
            this.maxX = 2.1474836E9f;
            this.maxY = 2.1474836E9f;
        }
    }

    private void aabbCompute() {
        float f = 2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = -2.1474836E9f;
        float f4 = -2.1474836E9f;
        FloatArray[] floatArrayArray = (FloatArray[])this.polygons.items;
        int n = this.polygons.size;
        for (int i = 0; i < n; ++i) {
            FloatArray floatArray = floatArrayArray[i];
            float[] fArray = floatArray.items;
            int n2 = floatArray.size;
            for (int j = 0; j < n2; j += 2) {
                float f5 = fArray[j];
                float f6 = fArray[j + 1];
                f = Math.min(f, f5);
                f2 = Math.min(f2, f6);
                f3 = Math.max(f3, f5);
                f4 = Math.max(f4, f6);
            }
        }
        this.minX = f;
        this.minY = f2;
        this.maxX = f3;
        this.maxY = f4;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getWidth() {
        return this.maxX - this.minX;
    }

    public float getHeight() {
        return this.maxY - this.minY;
    }

    public Array<BoundingBoxAttachment> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public Array<FloatArray> getPolygons() {
        return this.polygons;
    }
}

